<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ChangeTypeCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Contains list of types of changes allowed Name, Flight Services
 * @subpackage Enumerations
 */
class ChangeTypeCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Flight'
     * Meta information extracted from the WSDL
     * - documentation: This identifies Flight detail changes. changes to the core flight details. departure and arrival points and airline.
     * @return string 'Flight'
     */
    const VALUE_FLIGHT = 'Flight';
    /**
     * Constant for value 'Name'
     * Meta information extracted from the WSDL
     * - documentation: Name based changes. Changes to the passenger(s) names.
     * @return string 'Name'
     */
    const VALUE_NAME = 'Name';
    /**
     * Constant for value 'Service'
     * Meta information extracted from the WSDL
     * - documentation: This identifies Service non flight changes. seat preferences/food/baggage etc.
     * @return string 'Service'
     */
    const VALUE_SERVICE = 'Service';
    /**
     * Return allowed values
     * @uses self::VALUE_FLIGHT
     * @uses self::VALUE_NAME
     * @uses self::VALUE_SERVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FLIGHT,
            self::VALUE_NAME,
            self::VALUE_SERVICE,
        );
    }
}
