<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BagRuleCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration set for the currency application code Type BDT.
 * @subpackage Enumerations
 */
class BagRuleCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'D'
     * Meta information extracted from the WSDL
     * - documentation: Disclosure with NO US DOT Reservation
     * @return string 'D'
     */
    const VALUE_D = 'D';
    /**
     * Constant for value 'N'
     * Meta information extracted from the WSDL
     * - documentation: No Disclosure or US DOT Reservation
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Constant for value 'Other'
     * Meta information extracted from the WSDL
     * - documentation: Other
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Y'
     * Meta information extracted from the WSDL
     * - documentation: Disclosure and US DOT Reservation
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Return allowed values
     * @uses self::VALUE_D
     * @uses self::VALUE_N
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_Y
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_D,
            self::VALUE_N,
            self::VALUE_OTHER,
            self::VALUE_Y,
        );
    }
}
