<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueOfOldTicket StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the old ticketed total fare.
 * @subpackage Structs
 */
class ValueOfOldTicket extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The total fare amount including taxes of the old ticketed fare
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for ValueOfOldTicket
     * @uses ValueOfOldTicket::setAmount()
     * @param int $amount
     */
    public function __construct($amount = null)
    {
        $this
            ->setAmount($amount);
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\ValueOfOldTicket
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
