<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VAT_BreakdownElementType StructType
 * Meta information extracted from the WSDL
 * - documentation: Optional Information relating to VAT if an amount is reported gross. The information provided allows the VAT to be determined from the gross value amount.
 * @subpackage Structs
 */
class VAT_BreakdownElementType extends AbstractStructBase
{
    /**
     * The GrossAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount including VAT.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $GrossAmount;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount excluding VAT.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $NetAmount;
    /**
     * The VAT_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount of VAT.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $VAT_Amount;
    /**
     * The VAT_ThresholdAmount
     * Meta information extracted from the WSDL
     * - documentation: The portion for which VAT does not apply.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $VAT_ThresholdAmount;
    /**
     * The VAT_Percent
     * Meta information extracted from the WSDL
     * - documentation: The VAT percentage. | A percent is a value representing a fraction of one hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $VAT_Percent;
    /**
     * The VAT_ScopeText
     * Meta information extracted from the WSDL
     * - documentation: Defines the Amount Component that this VAT applies to e.g. BaseAmount, U0 (Tax) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $VAT_ScopeText;
    /**
     * Constructor method for VAT_BreakdownElementType
     * @uses VAT_BreakdownElementType::setGrossAmount()
     * @uses VAT_BreakdownElementType::setNetAmount()
     * @uses VAT_BreakdownElementType::setVAT_Amount()
     * @uses VAT_BreakdownElementType::setVAT_ThresholdAmount()
     * @uses VAT_BreakdownElementType::setVAT_Percent()
     * @uses VAT_BreakdownElementType::setVAT_ScopeText()
     * @param \StructType\AmountType $grossAmount
     * @param \StructType\AmountType $netAmount
     * @param \StructType\AmountType $vAT_Amount
     * @param \StructType\AmountType $vAT_ThresholdAmount
     * @param float $vAT_Percent
     * @param string[] $vAT_ScopeText
     */
    public function __construct(\StructType\AmountType $grossAmount = null, \StructType\AmountType $netAmount = null, \StructType\AmountType $vAT_Amount = null, \StructType\AmountType $vAT_ThresholdAmount = null, $vAT_Percent = null, array $vAT_ScopeText = array())
    {
        $this
            ->setGrossAmount($grossAmount)
            ->setNetAmount($netAmount)
            ->setVAT_Amount($vAT_Amount)
            ->setVAT_ThresholdAmount($vAT_ThresholdAmount)
            ->setVAT_Percent($vAT_Percent)
            ->setVAT_ScopeText($vAT_ScopeText);
    }
    /**
     * Get GrossAmount value
     * @return \StructType\AmountType
     */
    public function getGrossAmount()
    {
        return $this->GrossAmount;
    }
    /**
     * Set GrossAmount value
     * @param \StructType\AmountType $grossAmount
     * @return \StructType\VAT_BreakdownElementType
     */
    public function setGrossAmount(\StructType\AmountType $grossAmount = null)
    {
        $this->GrossAmount = $grossAmount;
        return $this;
    }
    /**
     * Get NetAmount value
     * @return \StructType\AmountType
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param \StructType\AmountType $netAmount
     * @return \StructType\VAT_BreakdownElementType
     */
    public function setNetAmount(\StructType\AmountType $netAmount = null)
    {
        $this->NetAmount = $netAmount;
        return $this;
    }
    /**
     * Get VAT_Amount value
     * @return \StructType\AmountType
     */
    public function getVAT_Amount()
    {
        return $this->VAT_Amount;
    }
    /**
     * Set VAT_Amount value
     * @param \StructType\AmountType $vAT_Amount
     * @return \StructType\VAT_BreakdownElementType
     */
    public function setVAT_Amount(\StructType\AmountType $vAT_Amount = null)
    {
        $this->VAT_Amount = $vAT_Amount;
        return $this;
    }
    /**
     * Get VAT_ThresholdAmount value
     * @return \StructType\AmountType
     */
    public function getVAT_ThresholdAmount()
    {
        return $this->VAT_ThresholdAmount;
    }
    /**
     * Set VAT_ThresholdAmount value
     * @param \StructType\AmountType $vAT_ThresholdAmount
     * @return \StructType\VAT_BreakdownElementType
     */
    public function setVAT_ThresholdAmount(\StructType\AmountType $vAT_ThresholdAmount = null)
    {
        $this->VAT_ThresholdAmount = $vAT_ThresholdAmount;
        return $this;
    }
    /**
     * Get VAT_Percent value
     * @return float|null
     */
    public function getVAT_Percent()
    {
        return $this->VAT_Percent;
    }
    /**
     * Set VAT_Percent value
     * @param float $vAT_Percent
     * @return \StructType\VAT_BreakdownElementType
     */
    public function setVAT_Percent($vAT_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($vAT_Percent) && !(is_float($vAT_Percent) || is_numeric($vAT_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vAT_Percent, true), gettype($vAT_Percent)), __LINE__);
        }
        $this->VAT_Percent = $vAT_Percent;
        return $this;
    }
    /**
     * Get VAT_ScopeText value
     * @return string[]|null
     */
    public function getVAT_ScopeText()
    {
        return $this->VAT_ScopeText;
    }
    /**
     * This method is responsible for validating the values passed to the setVAT_ScopeText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVAT_ScopeText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVAT_ScopeTextForArrayConstraintsFromSetVAT_ScopeText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vAT_BreakdownElementTypeVAT_ScopeTextItem) {
            // validation for constraint: itemType
            if (!is_string($vAT_BreakdownElementTypeVAT_ScopeTextItem)) {
                $invalidValues[] = is_object($vAT_BreakdownElementTypeVAT_ScopeTextItem) ? get_class($vAT_BreakdownElementTypeVAT_ScopeTextItem) : sprintf('%s(%s)', gettype($vAT_BreakdownElementTypeVAT_ScopeTextItem), var_export($vAT_BreakdownElementTypeVAT_ScopeTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VAT_ScopeText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VAT_ScopeText value
     * @throws \InvalidArgumentException
     * @param string[] $vAT_ScopeText
     * @return \StructType\VAT_BreakdownElementType
     */
    public function setVAT_ScopeText(array $vAT_ScopeText = array())
    {
        // validation for constraint: array
        if ('' !== ($vAT_ScopeTextArrayErrorMessage = self::validateVAT_ScopeTextForArrayConstraintsFromSetVAT_ScopeText($vAT_ScopeText))) {
            throw new \InvalidArgumentException($vAT_ScopeTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vAT_ScopeText) && count($vAT_ScopeText) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vAT_ScopeText)), __LINE__);
        }
        $this->VAT_ScopeText = $vAT_ScopeText;
        return $this;
    }
    /**
     * Add item to VAT_ScopeText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VAT_BreakdownElementType
     */
    public function addToVAT_ScopeText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VAT_ScopeText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VAT_ScopeText) && count($this->VAT_ScopeText) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VAT_ScopeText)), __LINE__);
        }
        $this->VAT_ScopeText[] = $item;
        return $this;
    }
}
