<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserText StructType
 * Meta information extracted from the WSDL
 * - documentation: Individual user input
 * @subpackage Structs
 */
class UserText extends AbstractStructBase
{
    /**
     * The InputID
     * Meta information extracted from the WSDL
     * - documentation: Identifies this input value for backend component.Sample: PUTime,DOTime,Address,etc
     * - use: required
     * @var string
     */
    public $InputID;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The UserInstruction
     * Meta information extracted from the WSDL
     * - documentation: Provides instructions for user regarding the required input. A client app should use this as a label for the user input box
     * @var string
     */
    public $UserInstruction;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the user input is mandatory (required) or not (optional)Allowed values: Y/N
     * @var string
     */
    public $Required;
    /**
     * Constructor method for UserText
     * @uses UserText::setInputID()
     * @uses UserText::set_()
     * @uses UserText::setUserInstruction()
     * @uses UserText::setRequired()
     * @param string $inputID
     * @param string $_
     * @param string $userInstruction
     * @param string $required
     */
    public function __construct($inputID = null, $_ = null, $userInstruction = null, $required = null)
    {
        $this
            ->setInputID($inputID)
            ->set_($_)
            ->setUserInstruction($userInstruction)
            ->setRequired($required);
    }
    /**
     * Get InputID value
     * @return string
     */
    public function getInputID()
    {
        return $this->InputID;
    }
    /**
     * Set InputID value
     * @param string $inputID
     * @return \StructType\UserText
     */
    public function setInputID($inputID = null)
    {
        // validation for constraint: string
        if (!is_null($inputID) && !is_string($inputID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputID, true), gettype($inputID)), __LINE__);
        }
        $this->InputID = $inputID;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\UserText
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get UserInstruction value
     * @return string|null
     */
    public function getUserInstruction()
    {
        return $this->UserInstruction;
    }
    /**
     * Set UserInstruction value
     * @param string $userInstruction
     * @return \StructType\UserText
     */
    public function setUserInstruction($userInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($userInstruction) && !is_string($userInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInstruction, true), gettype($userInstruction)), __LINE__);
        }
        $this->UserInstruction = $userInstruction;
        return $this;
    }
    /**
     * Get Required value
     * @return string|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param string $required
     * @return \StructType\UserText
     */
    public function setRequired($required = null)
    {
        // validation for constraint: string
        if (!is_null($required) && !is_string($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
}
