<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateServiceNotifRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Update Service Notification Request message
 * @subpackage Structs
 */
class UpdateServiceNotifRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Delivered Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
     * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
     * passenger in an Order may hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DeliveredOrderType[]
     */
    public $Order;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDeliveryDataListsType
     */
    public $DataLists;
    /**
     * The PaymentProcessingSummary
     * Meta information extracted from the WSDL
     * - documentation: Payment Processing Delivery Response Summary Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentProcessingDeliveryRequestSummaryType[]
     */
    public $PaymentProcessingSummary;
    /**
     * Constructor method for UpdateServiceNotifRequestType
     * @uses UpdateServiceNotifRequestType::setOrder()
     * @uses UpdateServiceNotifRequestType::setDataLists()
     * @uses UpdateServiceNotifRequestType::setPaymentProcessingSummary()
     * @param \StructType\DeliveredOrderType[] $order
     * @param \StructType\ServiceDeliveryDataListsType $dataLists
     * @param \StructType\PaymentProcessingDeliveryRequestSummaryType[] $paymentProcessingSummary
     */
    public function __construct(array $order = array(), \StructType\ServiceDeliveryDataListsType $dataLists = null, array $paymentProcessingSummary = array())
    {
        $this
            ->setOrder($order)
            ->setDataLists($dataLists)
            ->setPaymentProcessingSummary($paymentProcessingSummary);
    }
    /**
     * Get Order value
     * @return \StructType\DeliveredOrderType[]
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateServiceNotifRequestTypeOrderItem) {
            // validation for constraint: itemType
            if (!$updateServiceNotifRequestTypeOrderItem instanceof \StructType\DeliveredOrderType) {
                $invalidValues[] = is_object($updateServiceNotifRequestTypeOrderItem) ? get_class($updateServiceNotifRequestTypeOrderItem) : sprintf('%s(%s)', gettype($updateServiceNotifRequestTypeOrderItem), var_export($updateServiceNotifRequestTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType[] $order
     * @return \StructType\UpdateServiceNotifRequestType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType $item
     * @return \StructType\UpdateServiceNotifRequestType
     */
    public function addToOrder(\StructType\DeliveredOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveredOrderType) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\ServiceDeliveryDataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\ServiceDeliveryDataListsType $dataLists
     * @return \StructType\UpdateServiceNotifRequestType
     */
    public function setDataLists(\StructType\ServiceDeliveryDataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get PaymentProcessingSummary value
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType[]|null
     */
    public function getPaymentProcessingSummary()
    {
        return $this->PaymentProcessingSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentProcessingSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentProcessingSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateServiceNotifRequestTypePaymentProcessingSummaryItem) {
            // validation for constraint: itemType
            if (!$updateServiceNotifRequestTypePaymentProcessingSummaryItem instanceof \StructType\PaymentProcessingDeliveryRequestSummaryType) {
                $invalidValues[] = is_object($updateServiceNotifRequestTypePaymentProcessingSummaryItem) ? get_class($updateServiceNotifRequestTypePaymentProcessingSummaryItem) : sprintf('%s(%s)', gettype($updateServiceNotifRequestTypePaymentProcessingSummaryItem), var_export($updateServiceNotifRequestTypePaymentProcessingSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryRequestSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryRequestSummaryType[] $paymentProcessingSummary
     * @return \StructType\UpdateServiceNotifRequestType
     */
    public function setPaymentProcessingSummary(array $paymentProcessingSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentProcessingSummaryArrayErrorMessage = self::validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary($paymentProcessingSummary))) {
            throw new \InvalidArgumentException($paymentProcessingSummaryArrayErrorMessage, __LINE__);
        }
        $this->PaymentProcessingSummary = $paymentProcessingSummary;
        return $this;
    }
    /**
     * Add item to PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryRequestSummaryType $item
     * @return \StructType\UpdateServiceNotifRequestType
     */
    public function addToPaymentProcessingSummary(\StructType\PaymentProcessingDeliveryRequestSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentProcessingDeliveryRequestSummaryType) {
            throw new \InvalidArgumentException(sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryRequestSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentProcessingSummary[] = $item;
        return $this;
    }
}
