<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Function to Add, Remove or Update the Passenger Details. Providing the New and Previous values together implies an Update.
 * @subpackage Structs
 */
class UpdatePaxType extends AbstractStructBase
{
    /**
     * The PaxSharingPref
     * Meta information extracted from the WSDL
     * - documentation: This will be used to identify a Passenger's sharing preference. The passenger can request that his/her information is not shared with other passengers in the same order. Additionally the passenger can be in a requested selected group
     * of passengers whom wish to not share with the remaining passengers in the booking . E.g could be a group of a family members in a larger group booking.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxSharingPrefType[]
     */
    public $PaxSharingPref;
    /**
     * Constructor method for UpdatePaxType
     * @uses UpdatePaxType::setPaxSharingPref()
     * @param \StructType\PaxSharingPrefType[] $paxSharingPref
     */
    public function __construct(array $paxSharingPref = array())
    {
        $this
            ->setPaxSharingPref($paxSharingPref);
    }
    /**
     * Get PaxSharingPref value
     * @return \StructType\PaxSharingPrefType[]|null
     */
    public function getPaxSharingPref()
    {
        return $this->PaxSharingPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSharingPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSharingPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSharingPrefForArrayConstraintsFromSetPaxSharingPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updatePaxTypePaxSharingPrefItem) {
            // validation for constraint: itemType
            if (!$updatePaxTypePaxSharingPrefItem instanceof \StructType\PaxSharingPrefType) {
                $invalidValues[] = is_object($updatePaxTypePaxSharingPrefItem) ? get_class($updatePaxTypePaxSharingPrefItem) : sprintf('%s(%s)', gettype($updatePaxTypePaxSharingPrefItem), var_export($updatePaxTypePaxSharingPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSharingPref property can only contain items of type \StructType\PaxSharingPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSharingPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSharingPrefType[] $paxSharingPref
     * @return \StructType\UpdatePaxType
     */
    public function setPaxSharingPref(array $paxSharingPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSharingPrefArrayErrorMessage = self::validatePaxSharingPrefForArrayConstraintsFromSetPaxSharingPref($paxSharingPref))) {
            throw new \InvalidArgumentException($paxSharingPrefArrayErrorMessage, __LINE__);
        }
        $this->PaxSharingPref = $paxSharingPref;
        return $this;
    }
    /**
     * Add item to PaxSharingPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSharingPrefType $item
     * @return \StructType\UpdatePaxType
     */
    public function addToPaxSharingPref(\StructType\PaxSharingPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxSharingPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaxSharingPref property can only contain items of type \StructType\PaxSharingPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSharingPref[] = $item;
        return $this;
    }
}
