<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Update Order
 * @subpackage Structs
 */
class UpdateOrderType extends AbstractStructBase
{
    /**
     * The CancelOrderRef
     * Meta information extracted from the WSDL
     * - documentation: Ability to cancel an entire Order
     * - choice: CancelOrderRef | ReshopOrder
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CancelOrderRefType
     */
    public $CancelOrderRef;
    /**
     * The ReshopOrder
     * Meta information extracted from the WSDL
     * - documentation: A reshop order type
     * - choice: CancelOrderRef | ReshopOrder
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReshopOrderType
     */
    public $ReshopOrder;
    /**
     * Constructor method for UpdateOrderType
     * @uses UpdateOrderType::setCancelOrderRef()
     * @uses UpdateOrderType::setReshopOrder()
     * @param \StructType\CancelOrderRefType $cancelOrderRef
     * @param \StructType\ReshopOrderType $reshopOrder
     */
    public function __construct(\StructType\CancelOrderRefType $cancelOrderRef = null, \StructType\ReshopOrderType $reshopOrder = null)
    {
        $this
            ->setCancelOrderRef($cancelOrderRef)
            ->setReshopOrder($reshopOrder);
    }
    /**
     * Get CancelOrderRef value
     * @return \StructType\CancelOrderRefType
     */
    public function getCancelOrderRef()
    {
        return isset($this->CancelOrderRef) ? $this->CancelOrderRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelOrderRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelOrderRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancelOrderRefForChoiceConstraintsFromSetCancelOrderRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReshopOrder',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelOrderRef can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelOrderRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CancelOrderRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CancelOrderRefType $cancelOrderRef
     * @return \StructType\UpdateOrderType
     */
    public function setCancelOrderRef(\StructType\CancelOrderRefType $cancelOrderRef = null)
    {
        // validation for constraint: choice(CancelOrderRef, ReshopOrder)
        if ('' !== ($cancelOrderRefChoiceErrorMessage = self::validateCancelOrderRefForChoiceConstraintsFromSetCancelOrderRef($cancelOrderRef))) {
            throw new \InvalidArgumentException($cancelOrderRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($cancelOrderRef) || (is_array($cancelOrderRef) && empty($cancelOrderRef))) {
            unset($this->CancelOrderRef);
        } else {
            $this->CancelOrderRef = $cancelOrderRef;
        }
        return $this;
    }
    /**
     * Get ReshopOrder value
     * @return \StructType\ReshopOrderType
     */
    public function getReshopOrder()
    {
        return isset($this->ReshopOrder) ? $this->ReshopOrder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReshopOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReshopOrder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReshopOrderForChoiceConstraintsFromSetReshopOrder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CancelOrderRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ReshopOrder can\'t be set as the property %s is already set. Only one property must be set among these properties: ReshopOrder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ReshopOrder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReshopOrderType $reshopOrder
     * @return \StructType\UpdateOrderType
     */
    public function setReshopOrder(\StructType\ReshopOrderType $reshopOrder = null)
    {
        // validation for constraint: choice(CancelOrderRef, ReshopOrder)
        if ('' !== ($reshopOrderChoiceErrorMessage = self::validateReshopOrderForChoiceConstraintsFromSetReshopOrder($reshopOrder))) {
            throw new \InvalidArgumentException($reshopOrderChoiceErrorMessage, __LINE__);
        }
        if (is_null($reshopOrder) || (is_array($reshopOrder) && empty($reshopOrder))) {
            unset($this->ReshopOrder);
        } else {
            $this->ReshopOrder = $reshopOrder;
        }
        return $this;
    }
}
