<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UATPReportingData StructType
 * Meta information extracted from the WSDL
 * - documentation: Data Elements required by UATP card issuers for report purposes
 * @subpackage Structs
 */
class UATPReportingData extends AbstractStructBase
{
    /**
     * The IK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IK
     */
    public $IK;
    /**
     * The KS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\KS
     */
    public $KS;
    /**
     * The DS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DS
     */
    public $DS;
    /**
     * The PK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PK
     */
    public $PK;
    /**
     * The PR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PR
     */
    public $PR;
    /**
     * The AK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AK
     */
    public $AK;
    /**
     * The AE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AE
     */
    public $AE;
    /**
     * The BD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BD
     */
    public $BD;
    /**
     * The RZ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RZ
     */
    public $RZ;
    /**
     * The AU
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AU
     */
    public $AU;
    /**
     * The PaymentRefID
     * Meta information extracted from the WSDL
     * - choice: PaymentRefID | CardNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $PaymentRefID;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - choice: PaymentRefID | CardNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $CardNumber;
    /**
     * Constructor method for UATPReportingData
     * @uses UATPReportingData::setIK()
     * @uses UATPReportingData::setKS()
     * @uses UATPReportingData::setDS()
     * @uses UATPReportingData::setPK()
     * @uses UATPReportingData::setPR()
     * @uses UATPReportingData::setAK()
     * @uses UATPReportingData::setAE()
     * @uses UATPReportingData::setBD()
     * @uses UATPReportingData::setRZ()
     * @uses UATPReportingData::setAU()
     * @uses UATPReportingData::setPaymentRefID()
     * @uses UATPReportingData::setCardNumber()
     * @param \StructType\IK $iK
     * @param \StructType\KS $kS
     * @param \StructType\DS $dS
     * @param \StructType\PK $pK
     * @param \StructType\PR $pR
     * @param \StructType\AK $aK
     * @param \StructType\AE $aE
     * @param \StructType\BD $bD
     * @param \StructType\RZ $rZ
     * @param \StructType\AU $aU
     * @param mixed $paymentRefID
     * @param mixed $cardNumber
     */
    public function __construct(\StructType\IK $iK = null, \StructType\KS $kS = null, \StructType\DS $dS = null, \StructType\PK $pK = null, \StructType\PR $pR = null, \StructType\AK $aK = null, \StructType\AE $aE = null, \StructType\BD $bD = null, \StructType\RZ $rZ = null, \StructType\AU $aU = null, $paymentRefID = null, $cardNumber = null)
    {
        $this
            ->setIK($iK)
            ->setKS($kS)
            ->setDS($dS)
            ->setPK($pK)
            ->setPR($pR)
            ->setAK($aK)
            ->setAE($aE)
            ->setBD($bD)
            ->setRZ($rZ)
            ->setAU($aU)
            ->setPaymentRefID($paymentRefID)
            ->setCardNumber($cardNumber);
    }
    /**
     * Get IK value
     * @return \StructType\IK|null
     */
    public function getIK()
    {
        return $this->IK;
    }
    /**
     * Set IK value
     * @param \StructType\IK $iK
     * @return \StructType\UATPReportingData
     */
    public function setIK(\StructType\IK $iK = null)
    {
        $this->IK = $iK;
        return $this;
    }
    /**
     * Get KS value
     * @return \StructType\KS|null
     */
    public function getKS()
    {
        return $this->KS;
    }
    /**
     * Set KS value
     * @param \StructType\KS $kS
     * @return \StructType\UATPReportingData
     */
    public function setKS(\StructType\KS $kS = null)
    {
        $this->KS = $kS;
        return $this;
    }
    /**
     * Get DS value
     * @return \StructType\DS|null
     */
    public function getDS()
    {
        return $this->DS;
    }
    /**
     * Set DS value
     * @param \StructType\DS $dS
     * @return \StructType\UATPReportingData
     */
    public function setDS(\StructType\DS $dS = null)
    {
        $this->DS = $dS;
        return $this;
    }
    /**
     * Get PK value
     * @return \StructType\PK|null
     */
    public function getPK()
    {
        return $this->PK;
    }
    /**
     * Set PK value
     * @param \StructType\PK $pK
     * @return \StructType\UATPReportingData
     */
    public function setPK(\StructType\PK $pK = null)
    {
        $this->PK = $pK;
        return $this;
    }
    /**
     * Get PR value
     * @return \StructType\PR|null
     */
    public function getPR()
    {
        return $this->PR;
    }
    /**
     * Set PR value
     * @param \StructType\PR $pR
     * @return \StructType\UATPReportingData
     */
    public function setPR(\StructType\PR $pR = null)
    {
        $this->PR = $pR;
        return $this;
    }
    /**
     * Get AK value
     * @return \StructType\AK|null
     */
    public function getAK()
    {
        return $this->AK;
    }
    /**
     * Set AK value
     * @param \StructType\AK $aK
     * @return \StructType\UATPReportingData
     */
    public function setAK(\StructType\AK $aK = null)
    {
        $this->AK = $aK;
        return $this;
    }
    /**
     * Get AE value
     * @return \StructType\AE|null
     */
    public function getAE()
    {
        return $this->AE;
    }
    /**
     * Set AE value
     * @param \StructType\AE $aE
     * @return \StructType\UATPReportingData
     */
    public function setAE(\StructType\AE $aE = null)
    {
        $this->AE = $aE;
        return $this;
    }
    /**
     * Get BD value
     * @return \StructType\BD|null
     */
    public function getBD()
    {
        return $this->BD;
    }
    /**
     * Set BD value
     * @param \StructType\BD $bD
     * @return \StructType\UATPReportingData
     */
    public function setBD(\StructType\BD $bD = null)
    {
        $this->BD = $bD;
        return $this;
    }
    /**
     * Get RZ value
     * @return \StructType\RZ|null
     */
    public function getRZ()
    {
        return $this->RZ;
    }
    /**
     * Set RZ value
     * @param \StructType\RZ $rZ
     * @return \StructType\UATPReportingData
     */
    public function setRZ(\StructType\RZ $rZ = null)
    {
        $this->RZ = $rZ;
        return $this;
    }
    /**
     * Get AU value
     * @return \StructType\AU|null
     */
    public function getAU()
    {
        return $this->AU;
    }
    /**
     * Set AU value
     * @param \StructType\AU $aU
     * @return \StructType\UATPReportingData
     */
    public function setAU(\StructType\AU $aU = null)
    {
        $this->AU = $aU;
        return $this;
    }
    /**
     * Get PaymentRefID value
     * @return mixed|null
     */
    public function getPaymentRefID()
    {
        return isset($this->PaymentRefID) ? $this->PaymentRefID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentRefID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentRefIDForChoiceConstraintsFromSetPaymentRefID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardNumber',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentRefID can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentRefID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentRefID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $paymentRefID
     * @return \StructType\UATPReportingData
     */
    public function setPaymentRefID($paymentRefID = null)
    {
        // validation for constraint: choice(PaymentRefID, CardNumber)
        if ('' !== ($paymentRefIDChoiceErrorMessage = self::validatePaymentRefIDForChoiceConstraintsFromSetPaymentRefID($paymentRefID))) {
            throw new \InvalidArgumentException($paymentRefIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentRefID) || (is_array($paymentRefID) && empty($paymentRefID))) {
            unset($this->PaymentRefID);
        } else {
            $this->PaymentRefID = $paymentRefID;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * @return mixed|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardNumberForChoiceConstraintsFromSetCardNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaymentRefID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: CardNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $cardNumber
     * @return \StructType\UATPReportingData
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: choice(PaymentRefID, CardNumber)
        if ('' !== ($cardNumberChoiceErrorMessage = self::validateCardNumberForChoiceConstraintsFromSetCardNumber($cardNumber))) {
            throw new \InvalidArgumentException($cardNumberChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
}
