<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelAgentType StructType
 * Meta information extracted from the WSDL
 * - documentation: A private retailer or public service individual that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and
 * package tours.
 * @subpackage Structs
 */
class TravelAgentType extends AbstractStructBase
{
    /**
     * The TravelAgentID
     * Meta information extracted from the WSDL
     * - documentation: Booking and Servicing Agent information. ID. Example: 98417900. Note: The ID correlates to the specified ID Type. | An identifier is a character string used to uniquely identify one instance of an object within an identification
     * scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TravelAgentID;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Agency/ Agent Identification Type. Example: 706 (IATA agency numeric code) Encoding Scheme: IATA Padis Codeset - List for data element 9893 (Identification Type, coded) | Additional BDT to specify travel agency type codes.
     * - base: TravelAgencyTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * Constructor method for TravelAgentType
     * @uses TravelAgentType::setTravelAgentID()
     * @uses TravelAgentType::setTypeCode()
     * @param string $travelAgentID
     * @param string $typeCode
     */
    public function __construct($travelAgentID = null, $typeCode = null)
    {
        $this
            ->setTravelAgentID($travelAgentID)
            ->setTypeCode($typeCode);
    }
    /**
     * Get TravelAgentID value
     * @return string
     */
    public function getTravelAgentID()
    {
        return $this->TravelAgentID;
    }
    /**
     * Set TravelAgentID value
     * @param string $travelAgentID
     * @return \StructType\TravelAgentType
     */
    public function setTravelAgentID($travelAgentID = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgentID) && !is_string($travelAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgentID, true), gettype($travelAgentID)), __LINE__);
        }
        $this->TravelAgentID = $travelAgentID;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\TravelAgentType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
}
