<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportPointType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a transport point location.
 * @subpackage Structs
 */
class TransportPointType extends AbstractStructBase
{
    /**
     * The IATA_LocationCode
     * Meta information extracted from the WSDL
     * - documentation: IATA 3-letter code defining the city or airport code. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IATA_LocationCode;
    /**
     * The AircraftScheduledDateTime
     * Meta information extracted from the WSDL
     * - documentation: The Scheduled Date and Time of Arrival of the aircraft at the terminal or departure gate at an airport. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and
     * fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AircraftScheduledDateTime;
    /**
     * The BoardingGateID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the gate. E.g. 'A5'. | The boarding gate identifier.
     * - base: xs:token
     * - maxLength: 8
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BoardingGateID;
    /**
     * The StationName
     * Meta information extracted from the WSDL
     * - documentation: Name of the station. E.g. George Bush Intercontinental Airport | Data type information for Station Name.
     * - base: xs:token
     * - maxLength: 256
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $StationName;
    /**
     * The TerminalName
     * Meta information extracted from the WSDL
     * - documentation: The name of the terminal. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TerminalName;
    /**
     * Constructor method for TransportPointType
     * @uses TransportPointType::setIATA_LocationCode()
     * @uses TransportPointType::setAircraftScheduledDateTime()
     * @uses TransportPointType::setBoardingGateID()
     * @uses TransportPointType::setStationName()
     * @uses TransportPointType::setTerminalName()
     * @param string $iATA_LocationCode
     * @param string $aircraftScheduledDateTime
     * @param string $boardingGateID
     * @param string $stationName
     * @param string $terminalName
     */
    public function __construct($iATA_LocationCode = null, $aircraftScheduledDateTime = null, $boardingGateID = null, $stationName = null, $terminalName = null)
    {
        $this
            ->setIATA_LocationCode($iATA_LocationCode)
            ->setAircraftScheduledDateTime($aircraftScheduledDateTime)
            ->setBoardingGateID($boardingGateID)
            ->setStationName($stationName)
            ->setTerminalName($terminalName);
    }
    /**
     * Get IATA_LocationCode value
     * @return string
     */
    public function getIATA_LocationCode()
    {
        return $this->IATA_LocationCode;
    }
    /**
     * Set IATA_LocationCode value
     * @param string $iATA_LocationCode
     * @return \StructType\TransportPointType
     */
    public function setIATA_LocationCode($iATA_LocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_LocationCode) && !is_string($iATA_LocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_LocationCode, true), gettype($iATA_LocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($iATA_LocationCode) && mb_strlen($iATA_LocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($iATA_LocationCode)), __LINE__);
        }
        $this->IATA_LocationCode = $iATA_LocationCode;
        return $this;
    }
    /**
     * Get AircraftScheduledDateTime value
     * @return string|null
     */
    public function getAircraftScheduledDateTime()
    {
        return $this->AircraftScheduledDateTime;
    }
    /**
     * Set AircraftScheduledDateTime value
     * @param string $aircraftScheduledDateTime
     * @return \StructType\TransportPointType
     */
    public function setAircraftScheduledDateTime($aircraftScheduledDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftScheduledDateTime) && !is_string($aircraftScheduledDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftScheduledDateTime, true), gettype($aircraftScheduledDateTime)), __LINE__);
        }
        $this->AircraftScheduledDateTime = $aircraftScheduledDateTime;
        return $this;
    }
    /**
     * Get BoardingGateID value
     * @return string|null
     */
    public function getBoardingGateID()
    {
        return $this->BoardingGateID;
    }
    /**
     * Set BoardingGateID value
     * @param string $boardingGateID
     * @return \StructType\TransportPointType
     */
    public function setBoardingGateID($boardingGateID = null)
    {
        // validation for constraint: string
        if (!is_null($boardingGateID) && !is_string($boardingGateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boardingGateID, true), gettype($boardingGateID)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($boardingGateID) && mb_strlen($boardingGateID) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($boardingGateID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($boardingGateID) && mb_strlen($boardingGateID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($boardingGateID)), __LINE__);
        }
        $this->BoardingGateID = $boardingGateID;
        return $this;
    }
    /**
     * Get StationName value
     * @return string|null
     */
    public function getStationName()
    {
        return $this->StationName;
    }
    /**
     * Set StationName value
     * @param string $stationName
     * @return \StructType\TransportPointType
     */
    public function setStationName($stationName = null)
    {
        // validation for constraint: string
        if (!is_null($stationName) && !is_string($stationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stationName, true), gettype($stationName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($stationName) && mb_strlen($stationName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($stationName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($stationName) && mb_strlen($stationName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($stationName)), __LINE__);
        }
        $this->StationName = $stationName;
        return $this;
    }
    /**
     * Get TerminalName value
     * @return string|null
     */
    public function getTerminalName()
    {
        return $this->TerminalName;
    }
    /**
     * Set TerminalName value
     * @param string $terminalName
     * @return \StructType\TransportPointType
     */
    public function setTerminalName($terminalName = null)
    {
        // validation for constraint: string
        if (!is_null($terminalName) && !is_string($terminalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalName, true), gettype($terminalName)), __LINE__);
        }
        $this->TerminalName = $terminalName;
        return $this;
    }
}
