<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketRefIdentificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional, identifying information used to identify a ticket.
 * @subpackage Structs
 */
class TicketRefIdentificationType extends AbstractStructBase
{
    /**
     * The RefID
     * Meta information extracted from the WSDL
     * - documentation: Additional reference identifier. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefID;
    /**
     * The RefTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Type code of the reservation control system/reference. PADIS 9893. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefTypeCode;
    /**
     * Constructor method for TicketRefIdentificationType
     * @uses TicketRefIdentificationType::setRefID()
     * @uses TicketRefIdentificationType::setRefTypeCode()
     * @param string $refID
     * @param string $refTypeCode
     */
    public function __construct($refID = null, $refTypeCode = null)
    {
        $this
            ->setRefID($refID)
            ->setRefTypeCode($refTypeCode);
    }
    /**
     * Get RefID value
     * @return string
     */
    public function getRefID()
    {
        return $this->RefID;
    }
    /**
     * Set RefID value
     * @param string $refID
     * @return \StructType\TicketRefIdentificationType
     */
    public function setRefID($refID = null)
    {
        // validation for constraint: string
        if (!is_null($refID) && !is_string($refID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refID, true), gettype($refID)), __LINE__);
        }
        $this->RefID = $refID;
        return $this;
    }
    /**
     * Get RefTypeCode value
     * @return string
     */
    public function getRefTypeCode()
    {
        return $this->RefTypeCode;
    }
    /**
     * Set RefTypeCode value
     * @param string $refTypeCode
     * @return \StructType\TicketRefIdentificationType
     */
    public function setRefTypeCode($refTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($refTypeCode) && !is_string($refTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refTypeCode, true), gettype($refTypeCode)), __LINE__);
        }
        $this->RefTypeCode = $refTypeCode;
        return $this;
    }
}
