<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketIssuanceInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The issuing carrier and issuing location of a ticket.
 * @subpackage Structs
 */
class TicketIssuanceInfoType extends AbstractStructBase
{
    /**
     * The IssuingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CarrierType
     */
    public $IssuingCarrier;
    /**
     * The IATA_LocationCode
     * Meta information extracted from the WSDL
     * - documentation: IATA defined code identifying a city or station. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IATA_LocationCode;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - documentation: The date that the document was originally issued. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - documentation: The time that the document was originally issued. | Time is a point in the 24 hour clock expressed in hours, minutes and seconds. It has no implicit reference to a time zone.
     * - base: xs:time
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueTime;
    /**
     * The TravelAgency
     * Meta information extracted from the WSDL
     * - documentation: A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package
     * tours.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TravelAgencyType
     */
    public $TravelAgency;
    /**
     * Constructor method for TicketIssuanceInfoType
     * @uses TicketIssuanceInfoType::setIssuingCarrier()
     * @uses TicketIssuanceInfoType::setIATA_LocationCode()
     * @uses TicketIssuanceInfoType::setIssueDate()
     * @uses TicketIssuanceInfoType::setIssueTime()
     * @uses TicketIssuanceInfoType::setTravelAgency()
     * @param \StructType\CarrierType $issuingCarrier
     * @param string $iATA_LocationCode
     * @param string $issueDate
     * @param string $issueTime
     * @param \StructType\TravelAgencyType $travelAgency
     */
    public function __construct(\StructType\CarrierType $issuingCarrier = null, $iATA_LocationCode = null, $issueDate = null, $issueTime = null, \StructType\TravelAgencyType $travelAgency = null)
    {
        $this
            ->setIssuingCarrier($issuingCarrier)
            ->setIATA_LocationCode($iATA_LocationCode)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setTravelAgency($travelAgency);
    }
    /**
     * Get IssuingCarrier value
     * @return \StructType\CarrierType
     */
    public function getIssuingCarrier()
    {
        return $this->IssuingCarrier;
    }
    /**
     * Set IssuingCarrier value
     * @param \StructType\CarrierType $issuingCarrier
     * @return \StructType\TicketIssuanceInfoType
     */
    public function setIssuingCarrier(\StructType\CarrierType $issuingCarrier = null)
    {
        $this->IssuingCarrier = $issuingCarrier;
        return $this;
    }
    /**
     * Get IATA_LocationCode value
     * @return string|null
     */
    public function getIATA_LocationCode()
    {
        return $this->IATA_LocationCode;
    }
    /**
     * Set IATA_LocationCode value
     * @param string $iATA_LocationCode
     * @return \StructType\TicketIssuanceInfoType
     */
    public function setIATA_LocationCode($iATA_LocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_LocationCode) && !is_string($iATA_LocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_LocationCode, true), gettype($iATA_LocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($iATA_LocationCode) && mb_strlen($iATA_LocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($iATA_LocationCode)), __LINE__);
        }
        $this->IATA_LocationCode = $iATA_LocationCode;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\TicketIssuanceInfoType
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return string|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param string $issueTime
     * @return \StructType\TicketIssuanceInfoType
     */
    public function setIssueTime($issueTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueTime) && !is_string($issueTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueTime, true), gettype($issueTime)), __LINE__);
        }
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get TravelAgency value
     * @return \StructType\TravelAgencyType|null
     */
    public function getTravelAgency()
    {
        return $this->TravelAgency;
    }
    /**
     * Set TravelAgency value
     * @param \StructType\TravelAgencyType $travelAgency
     * @return \StructType\TicketIssuanceInfoType
     */
    public function setTravelAgency(\StructType\TravelAgencyType $travelAgency = null)
    {
        $this->TravelAgency = $travelAgency;
        return $this;
    }
}
