<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDocInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information corresponding to a group of 1 to 4 Tickets for a single Origin Destination and a single Passenger.
 * @subpackage Structs
 */
class TicketDocInfoType extends AbstractStructBase
{
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The BaggageAllowanceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a BaggageAllowanceID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $BaggageAllowanceRefID;
    /**
     * The BookingAgency
     * Meta information extracted from the WSDL
     * - documentation: A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package
     * tours.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TravelAgencyType
     */
    public $BookingAgency;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The BookletQty
     * Meta information extracted from the WSDL
     * - documentation: Number of booklets issued for a given ticket/ document set. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $BookletQty;
    /**
     * The CarrierFee
     * Meta information extracted from the WSDL
     * - documentation: Carrier imposed fee detail, typically related to booking, ticketing, or servicing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierFeeType
     */
    public $CarrierFee;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The EndorsementText
     * Meta information extracted from the WSDL
     * - documentation: Endorsement and restriction information applied for this set of ticket / document information. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndorsementText;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FareDetailType
     */
    public $FareDetail;
    /**
     * The IssueInfo
     * Meta information extracted from the WSDL
     * - documentation: The issuing Carrier and issuing location of a ticket.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TicketIssuanceInfoType
     */
    public $IssueInfo;
    /**
     * The OriginalIssueInfo
     * Meta information extracted from the WSDL
     * - documentation: An Original issuing carrier and issuing location and ticket number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OriginalTicketIssuanceInfoType
     */
    public $OriginalIssueInfo;
    /**
     * The OriginDest
     * Meta information extracted from the WSDL
     * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OriginDestType
     */
    public $OriginDest;
    /**
     * The PaymentRefID
     * Meta information extracted from the WSDL
     * - documentation: References a payment transaction within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentRefID;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The PricingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: The country code used to identify the country in which the booked itinerary was priced. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166 two-alpha Country
     * Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $PricingCountryCode;
    /**
     * The PricingDate
     * Meta information extracted from the WSDL
     * - documentation: Booked Itinerary Pricing Date. Example: 2017-01-13 Note: This is the date the booked itinerary was priced. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricingDate;
    /**
     * The PricingLocationCode
     * Meta information extracted from the WSDL
     * - documentation: IATA defined code identifying a city or station. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricingLocationCode;
    /**
     * The PricingTime
     * Meta information extracted from the WSDL
     * - documentation: Booked Itinerary Pricing Time. Example: 09:15 | Time is a point in the 24 hour clock expressed in hours, minutes and seconds. It has no implicit reference to a time zone.
     * - base: xs:time
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricingTime;
    /**
     * The ReferencedOrder
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderStructureKeyType
     */
    public $ReferencedOrder;
    /**
     * The ServicingAgency
     * Meta information extracted from the WSDL
     * - documentation: A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package
     * tours.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TravelAgencyType
     */
    public $ServicingAgency;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - documentation: The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\TicketType[]
     */
    public $Ticket;
    /**
     * The TicketRefIdentification
     * Meta information extracted from the WSDL
     * - documentation: Additional, identifying information used to identify a ticket.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\TicketRefIdentificationType[]
     */
    public $TicketRefIdentification;
    /**
     * Constructor method for TicketDocInfoType
     * @uses TicketDocInfoType::setPaxRefID()
     * @uses TicketDocInfoType::setBaggageAllowanceRefID()
     * @uses TicketDocInfoType::setBookingAgency()
     * @uses TicketDocInfoType::setBookingRef()
     * @uses TicketDocInfoType::setBookletQty()
     * @uses TicketDocInfoType::setCarrierFee()
     * @uses TicketDocInfoType::setCommission()
     * @uses TicketDocInfoType::setEndorsementText()
     * @uses TicketDocInfoType::setFareDetail()
     * @uses TicketDocInfoType::setIssueInfo()
     * @uses TicketDocInfoType::setOriginalIssueInfo()
     * @uses TicketDocInfoType::setOriginDest()
     * @uses TicketDocInfoType::setPaymentRefID()
     * @uses TicketDocInfoType::setPenaltyRefID()
     * @uses TicketDocInfoType::setPricingCountryCode()
     * @uses TicketDocInfoType::setPricingDate()
     * @uses TicketDocInfoType::setPricingLocationCode()
     * @uses TicketDocInfoType::setPricingTime()
     * @uses TicketDocInfoType::setReferencedOrder()
     * @uses TicketDocInfoType::setServicingAgency()
     * @uses TicketDocInfoType::setTicket()
     * @uses TicketDocInfoType::setTicketRefIdentification()
     * @param string $paxRefID
     * @param string[] $baggageAllowanceRefID
     * @param \StructType\TravelAgencyType $bookingAgency
     * @param \StructType\BookingRefType[] $bookingRef
     * @param float $bookletQty
     * @param \StructType\CarrierFeeType $carrierFee
     * @param \StructType\CommissionType[] $commission
     * @param string $endorsementText
     * @param \StructType\FareDetailType $fareDetail
     * @param \StructType\TicketIssuanceInfoType $issueInfo
     * @param \StructType\OriginalTicketIssuanceInfoType $originalIssueInfo
     * @param \StructType\OriginDestType $originDest
     * @param string[] $paymentRefID
     * @param string[] $penaltyRefID
     * @param string $pricingCountryCode
     * @param string $pricingDate
     * @param string $pricingLocationCode
     * @param string $pricingTime
     * @param \StructType\OrderStructureKeyType $referencedOrder
     * @param \StructType\TravelAgencyType $servicingAgency
     * @param \StructType\TicketType[] $ticket
     * @param \StructType\TicketRefIdentificationType[] $ticketRefIdentification
     */
    public function __construct($paxRefID = null, array $baggageAllowanceRefID = array(), \StructType\TravelAgencyType $bookingAgency = null, array $bookingRef = array(), $bookletQty = null, \StructType\CarrierFeeType $carrierFee = null, array $commission = array(), $endorsementText = null, \StructType\FareDetailType $fareDetail = null, \StructType\TicketIssuanceInfoType $issueInfo = null, \StructType\OriginalTicketIssuanceInfoType $originalIssueInfo = null, \StructType\OriginDestType $originDest = null, array $paymentRefID = array(), array $penaltyRefID = array(), $pricingCountryCode = null, $pricingDate = null, $pricingLocationCode = null, $pricingTime = null, \StructType\OrderStructureKeyType $referencedOrder = null, \StructType\TravelAgencyType $servicingAgency = null, array $ticket = array(), array $ticketRefIdentification = array())
    {
        $this
            ->setPaxRefID($paxRefID)
            ->setBaggageAllowanceRefID($baggageAllowanceRefID)
            ->setBookingAgency($bookingAgency)
            ->setBookingRef($bookingRef)
            ->setBookletQty($bookletQty)
            ->setCarrierFee($carrierFee)
            ->setCommission($commission)
            ->setEndorsementText($endorsementText)
            ->setFareDetail($fareDetail)
            ->setIssueInfo($issueInfo)
            ->setOriginalIssueInfo($originalIssueInfo)
            ->setOriginDest($originDest)
            ->setPaymentRefID($paymentRefID)
            ->setPenaltyRefID($penaltyRefID)
            ->setPricingCountryCode($pricingCountryCode)
            ->setPricingDate($pricingDate)
            ->setPricingLocationCode($pricingLocationCode)
            ->setPricingTime($pricingTime)
            ->setReferencedOrder($referencedOrder)
            ->setServicingAgency($servicingAgency)
            ->setTicket($ticket)
            ->setTicketRefIdentification($ticketRefIdentification);
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\TicketDocInfoType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get BaggageAllowanceRefID value
     * @return string[]|null
     */
    public function getBaggageAllowanceRefID()
    {
        return $this->BaggageAllowanceRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageAllowanceRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageAllowanceRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocInfoTypeBaggageAllowanceRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($ticketDocInfoTypeBaggageAllowanceRefIDItem)) {
                $invalidValues[] = is_object($ticketDocInfoTypeBaggageAllowanceRefIDItem) ? get_class($ticketDocInfoTypeBaggageAllowanceRefIDItem) : sprintf('%s(%s)', gettype($ticketDocInfoTypeBaggageAllowanceRefIDItem), var_export($ticketDocInfoTypeBaggageAllowanceRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string[] $baggageAllowanceRefID
     * @return \StructType\TicketDocInfoType
     */
    public function setBaggageAllowanceRefID(array $baggageAllowanceRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageAllowanceRefIDArrayErrorMessage = self::validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID($baggageAllowanceRefID))) {
            throw new \InvalidArgumentException($baggageAllowanceRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($baggageAllowanceRefID) && count($baggageAllowanceRefID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($baggageAllowanceRefID)), __LINE__);
        }
        $this->BaggageAllowanceRefID = $baggageAllowanceRefID;
        return $this;
    }
    /**
     * Add item to BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketDocInfoType
     */
    public function addToBaggageAllowanceRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BaggageAllowanceRefID) && count($this->BaggageAllowanceRefID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BaggageAllowanceRefID)), __LINE__);
        }
        $this->BaggageAllowanceRefID[] = $item;
        return $this;
    }
    /**
     * Get BookingAgency value
     * @return \StructType\TravelAgencyType|null
     */
    public function getBookingAgency()
    {
        return $this->BookingAgency;
    }
    /**
     * Set BookingAgency value
     * @param \StructType\TravelAgencyType $bookingAgency
     * @return \StructType\TicketDocInfoType
     */
    public function setBookingAgency(\StructType\TravelAgencyType $bookingAgency = null)
    {
        $this->BookingAgency = $bookingAgency;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocInfoTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$ticketDocInfoTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($ticketDocInfoTypeBookingRefItem) ? get_class($ticketDocInfoTypeBookingRefItem) : sprintf('%s(%s)', gettype($ticketDocInfoTypeBookingRefItem), var_export($ticketDocInfoTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\TicketDocInfoType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\TicketDocInfoType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get BookletQty value
     * @return float|null
     */
    public function getBookletQty()
    {
        return $this->BookletQty;
    }
    /**
     * Set BookletQty value
     * @param float $bookletQty
     * @return \StructType\TicketDocInfoType
     */
    public function setBookletQty($bookletQty = null)
    {
        // validation for constraint: float
        if (!is_null($bookletQty) && !(is_float($bookletQty) || is_numeric($bookletQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookletQty, true), gettype($bookletQty)), __LINE__);
        }
        $this->BookletQty = $bookletQty;
        return $this;
    }
    /**
     * Get CarrierFee value
     * @return \StructType\CarrierFeeType|null
     */
    public function getCarrierFee()
    {
        return $this->CarrierFee;
    }
    /**
     * Set CarrierFee value
     * @param \StructType\CarrierFeeType $carrierFee
     * @return \StructType\TicketDocInfoType
     */
    public function setCarrierFee(\StructType\CarrierFeeType $carrierFee = null)
    {
        $this->CarrierFee = $carrierFee;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocInfoTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$ticketDocInfoTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($ticketDocInfoTypeCommissionItem) ? get_class($ticketDocInfoTypeCommissionItem) : sprintf('%s(%s)', gettype($ticketDocInfoTypeCommissionItem), var_export($ticketDocInfoTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\TicketDocInfoType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\TicketDocInfoType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get EndorsementText value
     * @return string|null
     */
    public function getEndorsementText()
    {
        return $this->EndorsementText;
    }
    /**
     * Set EndorsementText value
     * @param string $endorsementText
     * @return \StructType\TicketDocInfoType
     */
    public function setEndorsementText($endorsementText = null)
    {
        // validation for constraint: string
        if (!is_null($endorsementText) && !is_string($endorsementText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endorsementText, true), gettype($endorsementText)), __LINE__);
        }
        $this->EndorsementText = $endorsementText;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * Set FareDetail value
     * @param \StructType\FareDetailType $fareDetail
     * @return \StructType\TicketDocInfoType
     */
    public function setFareDetail(\StructType\FareDetailType $fareDetail = null)
    {
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Get IssueInfo value
     * @return \StructType\TicketIssuanceInfoType|null
     */
    public function getIssueInfo()
    {
        return $this->IssueInfo;
    }
    /**
     * Set IssueInfo value
     * @param \StructType\TicketIssuanceInfoType $issueInfo
     * @return \StructType\TicketDocInfoType
     */
    public function setIssueInfo(\StructType\TicketIssuanceInfoType $issueInfo = null)
    {
        $this->IssueInfo = $issueInfo;
        return $this;
    }
    /**
     * Get OriginalIssueInfo value
     * @return \StructType\OriginalTicketIssuanceInfoType|null
     */
    public function getOriginalIssueInfo()
    {
        return $this->OriginalIssueInfo;
    }
    /**
     * Set OriginalIssueInfo value
     * @param \StructType\OriginalTicketIssuanceInfoType $originalIssueInfo
     * @return \StructType\TicketDocInfoType
     */
    public function setOriginalIssueInfo(\StructType\OriginalTicketIssuanceInfoType $originalIssueInfo = null)
    {
        $this->OriginalIssueInfo = $originalIssueInfo;
        return $this;
    }
    /**
     * Get OriginDest value
     * @return \StructType\OriginDestType|null
     */
    public function getOriginDest()
    {
        return $this->OriginDest;
    }
    /**
     * Set OriginDest value
     * @param \StructType\OriginDestType $originDest
     * @return \StructType\TicketDocInfoType
     */
    public function setOriginDest(\StructType\OriginDestType $originDest = null)
    {
        $this->OriginDest = $originDest;
        return $this;
    }
    /**
     * Get PaymentRefID value
     * @return string[]|null
     */
    public function getPaymentRefID()
    {
        return $this->PaymentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentRefIDForArrayConstraintsFromSetPaymentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocInfoTypePaymentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($ticketDocInfoTypePaymentRefIDItem)) {
                $invalidValues[] = is_object($ticketDocInfoTypePaymentRefIDItem) ? get_class($ticketDocInfoTypePaymentRefIDItem) : sprintf('%s(%s)', gettype($ticketDocInfoTypePaymentRefIDItem), var_export($ticketDocInfoTypePaymentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paymentRefID
     * @return \StructType\TicketDocInfoType
     */
    public function setPaymentRefID(array $paymentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentRefIDArrayErrorMessage = self::validatePaymentRefIDForArrayConstraintsFromSetPaymentRefID($paymentRefID))) {
            throw new \InvalidArgumentException($paymentRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaymentRefID = $paymentRefID;
        return $this;
    }
    /**
     * Add item to PaymentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketDocInfoType
     */
    public function addToPaymentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaymentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentRefID[] = $item;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocInfoTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($ticketDocInfoTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($ticketDocInfoTypePenaltyRefIDItem) ? get_class($ticketDocInfoTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($ticketDocInfoTypePenaltyRefIDItem), var_export($ticketDocInfoTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\TicketDocInfoType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketDocInfoType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get PricingCountryCode value
     * @return string|null
     */
    public function getPricingCountryCode()
    {
        return $this->PricingCountryCode;
    }
    /**
     * Set PricingCountryCode value
     * @param string $pricingCountryCode
     * @return \StructType\TicketDocInfoType
     */
    public function setPricingCountryCode($pricingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($pricingCountryCode) && !is_string($pricingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingCountryCode, true), gettype($pricingCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($pricingCountryCode) && !preg_match('/[A-Z]{2}/', $pricingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($pricingCountryCode, true)), __LINE__);
        }
        $this->PricingCountryCode = $pricingCountryCode;
        return $this;
    }
    /**
     * Get PricingDate value
     * @return string|null
     */
    public function getPricingDate()
    {
        return $this->PricingDate;
    }
    /**
     * Set PricingDate value
     * @param string $pricingDate
     * @return \StructType\TicketDocInfoType
     */
    public function setPricingDate($pricingDate = null)
    {
        // validation for constraint: string
        if (!is_null($pricingDate) && !is_string($pricingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingDate, true), gettype($pricingDate)), __LINE__);
        }
        $this->PricingDate = $pricingDate;
        return $this;
    }
    /**
     * Get PricingLocationCode value
     * @return string|null
     */
    public function getPricingLocationCode()
    {
        return $this->PricingLocationCode;
    }
    /**
     * Set PricingLocationCode value
     * @param string $pricingLocationCode
     * @return \StructType\TicketDocInfoType
     */
    public function setPricingLocationCode($pricingLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($pricingLocationCode) && !is_string($pricingLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingLocationCode, true), gettype($pricingLocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($pricingLocationCode) && mb_strlen($pricingLocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($pricingLocationCode)), __LINE__);
        }
        $this->PricingLocationCode = $pricingLocationCode;
        return $this;
    }
    /**
     * Get PricingTime value
     * @return string|null
     */
    public function getPricingTime()
    {
        return $this->PricingTime;
    }
    /**
     * Set PricingTime value
     * @param string $pricingTime
     * @return \StructType\TicketDocInfoType
     */
    public function setPricingTime($pricingTime = null)
    {
        // validation for constraint: string
        if (!is_null($pricingTime) && !is_string($pricingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingTime, true), gettype($pricingTime)), __LINE__);
        }
        $this->PricingTime = $pricingTime;
        return $this;
    }
    /**
     * Get ReferencedOrder value
     * @return \StructType\OrderStructureKeyType|null
     */
    public function getReferencedOrder()
    {
        return $this->ReferencedOrder;
    }
    /**
     * Set ReferencedOrder value
     * @param \StructType\OrderStructureKeyType $referencedOrder
     * @return \StructType\TicketDocInfoType
     */
    public function setReferencedOrder(\StructType\OrderStructureKeyType $referencedOrder = null)
    {
        $this->ReferencedOrder = $referencedOrder;
        return $this;
    }
    /**
     * Get ServicingAgency value
     * @return \StructType\TravelAgencyType|null
     */
    public function getServicingAgency()
    {
        return $this->ServicingAgency;
    }
    /**
     * Set ServicingAgency value
     * @param \StructType\TravelAgencyType $servicingAgency
     * @return \StructType\TicketDocInfoType
     */
    public function setServicingAgency(\StructType\TravelAgencyType $servicingAgency = null)
    {
        $this->ServicingAgency = $servicingAgency;
        return $this;
    }
    /**
     * Get Ticket value
     * @return \StructType\TicketType[]|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * This method is responsible for validating the values passed to the setTicket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketForArrayConstraintsFromSetTicket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocInfoTypeTicketItem) {
            // validation for constraint: itemType
            if (!$ticketDocInfoTypeTicketItem instanceof \StructType\TicketType) {
                $invalidValues[] = is_object($ticketDocInfoTypeTicketItem) ? get_class($ticketDocInfoTypeTicketItem) : sprintf('%s(%s)', gettype($ticketDocInfoTypeTicketItem), var_export($ticketDocInfoTypeTicketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ticket property can only contain items of type \StructType\TicketType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ticket value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketType[] $ticket
     * @return \StructType\TicketDocInfoType
     */
    public function setTicket(array $ticket = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketArrayErrorMessage = self::validateTicketForArrayConstraintsFromSetTicket($ticket))) {
            throw new \InvalidArgumentException($ticketArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($ticket) && count($ticket) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Add item to Ticket value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketType $item
     * @return \StructType\TicketDocInfoType
     */
    public function addToTicket(\StructType\TicketType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketType) {
            throw new \InvalidArgumentException(sprintf('The Ticket property can only contain items of type \StructType\TicketType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Ticket) && count($this->Ticket) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Ticket)), __LINE__);
        }
        $this->Ticket[] = $item;
        return $this;
    }
    /**
     * Get TicketRefIdentification value
     * @return \StructType\TicketRefIdentificationType[]|null
     */
    public function getTicketRefIdentification()
    {
        return $this->TicketRefIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketRefIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketRefIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketRefIdentificationForArrayConstraintsFromSetTicketRefIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketDocInfoTypeTicketRefIdentificationItem) {
            // validation for constraint: itemType
            if (!$ticketDocInfoTypeTicketRefIdentificationItem instanceof \StructType\TicketRefIdentificationType) {
                $invalidValues[] = is_object($ticketDocInfoTypeTicketRefIdentificationItem) ? get_class($ticketDocInfoTypeTicketRefIdentificationItem) : sprintf('%s(%s)', gettype($ticketDocInfoTypeTicketRefIdentificationItem), var_export($ticketDocInfoTypeTicketRefIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketRefIdentification property can only contain items of type \StructType\TicketRefIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketRefIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketRefIdentificationType[] $ticketRefIdentification
     * @return \StructType\TicketDocInfoType
     */
    public function setTicketRefIdentification(array $ticketRefIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketRefIdentificationArrayErrorMessage = self::validateTicketRefIdentificationForArrayConstraintsFromSetTicketRefIdentification($ticketRefIdentification))) {
            throw new \InvalidArgumentException($ticketRefIdentificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($ticketRefIdentification) && count($ticketRefIdentification) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($ticketRefIdentification)), __LINE__);
        }
        $this->TicketRefIdentification = $ticketRefIdentification;
        return $this;
    }
    /**
     * Add item to TicketRefIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketRefIdentificationType $item
     * @return \StructType\TicketDocInfoType
     */
    public function addToTicketRefIdentification(\StructType\TicketRefIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketRefIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The TicketRefIdentification property can only contain items of type \StructType\TicketRefIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->TicketRefIdentification) && count($this->TicketRefIdentification) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->TicketRefIdentification)), __LINE__);
        }
        $this->TicketRefIdentification[] = $item;
        return $this;
    }
}
