<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TermsListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer/Order Terms list
 * @subpackage Structs
 */
class TermsListType extends AbstractStructBase
{
    /**
     * The Term
     * Meta information extracted from the WSDL
     * - documentation: Condition under which an agreement is reached.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\TermType[]
     */
    public $Term;
    /**
     * Constructor method for TermsListType
     * @uses TermsListType::setTerm()
     * @param \StructType\TermType[] $term
     */
    public function __construct(array $term = array())
    {
        $this
            ->setTerm($term);
    }
    /**
     * Get Term value
     * @return \StructType\TermType[]
     */
    public function getTerm()
    {
        return $this->Term;
    }
    /**
     * This method is responsible for validating the values passed to the setTerm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTerm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermForArrayConstraintsFromSetTerm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $termsListTypeTermItem) {
            // validation for constraint: itemType
            if (!$termsListTypeTermItem instanceof \StructType\TermType) {
                $invalidValues[] = is_object($termsListTypeTermItem) ? get_class($termsListTypeTermItem) : sprintf('%s(%s)', gettype($termsListTypeTermItem), var_export($termsListTypeTermItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Term property can only contain items of type \StructType\TermType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Term value
     * @throws \InvalidArgumentException
     * @param \StructType\TermType[] $term
     * @return \StructType\TermsListType
     */
    public function setTerm(array $term = array())
    {
        // validation for constraint: array
        if ('' !== ($termArrayErrorMessage = self::validateTermForArrayConstraintsFromSetTerm($term))) {
            throw new \InvalidArgumentException($termArrayErrorMessage, __LINE__);
        }
        $this->Term = $term;
        return $this;
    }
    /**
     * Add item to Term value
     * @throws \InvalidArgumentException
     * @param \StructType\TermType $item
     * @return \StructType\TermsListType
     */
    public function addToTerm(\StructType\TermType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TermType) {
            throw new \InvalidArgumentException(sprintf('The Term property can only contain items of type \StructType\TermType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Term[] = $item;
        return $this;
    }
}
