<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: A compulsory contribution to state revenue, levied by the government on workers' income and business profits or added to the cost of some goods, services, and transactions.
 * @subpackage Structs
 */
class TaxType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Tax amount. Example: 15000 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The AddlFiledTaxCode
     * Meta information extracted from the WSDL
     * - documentation: A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddlFiledTaxCode;
    /**
     * The AddlTaxCode
     * Meta information extracted from the WSDL
     * - documentation: A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddlTaxCode;
    /**
     * The ApproximateInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this tax amount is approximate. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ApproximateInd;
    /**
     * The AppTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates at which point the tax was applied (e.g. S - Sale, D - Departure, A - Arrival, X - Delivery). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppTypeCode;
    /**
     * The CollectionInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this tax must be collected. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CollectionInd;
    /**
     * The CollectionPointTax
     * Meta information extracted from the WSDL
     * - documentation: Tax data breakdown by collection point for XF(Passenger Facility Fee) and ZP(federal tax segment) taxes.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CollectionPointTax[]
     */
    public $CollectionPointTax;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: A nation with its own government, occupying a particular territory.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountryType
     */
    public $Country;
    /**
     * The CountrySubDivision
     * Meta information extracted from the WSDL
     * - documentation: An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountrySubDivision
     */
    public $CountrySubDivision;
    /**
     * The CurConversion
     * Meta information extracted from the WSDL
     * - documentation: The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurConversionType
     */
    public $CurConversion;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Tax short description. Example: $4 per flight segment, per passenger (U.S. domestic segment tax) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The FiledAmount
     * Meta information extracted from the WSDL
     * - documentation: Internal tax filed amount as determined by the airline.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $FiledAmount;
    /**
     * The FiledTaxCode
     * Meta information extracted from the WSDL
     * - documentation: Internal tax filed type code as determined by the airline.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FiledTaxCode;
    /**
     * The QualifierCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify if current, paid, additional taxes Refer to IATA PADIS Code list data element 5305.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QualifierCode;
    /**
     * The RefundInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this tax is refundable. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RefundInd;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - documentation: IATA TTBS Tax Code. Example: AY, GB
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxName
     * Meta information extracted from the WSDL
     * - documentation: The name given to describe the tax. For example, this name can be taken from the IATA TTBS | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxName;
    /**
     * The TaxTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Tax type code (e.g. Applied or Exempt).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxTypeCode;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setAmount()
     * @uses TaxType::setAddlFiledTaxCode()
     * @uses TaxType::setAddlTaxCode()
     * @uses TaxType::setApproximateInd()
     * @uses TaxType::setAppTypeCode()
     * @uses TaxType::setCollectionInd()
     * @uses TaxType::setCollectionPointTax()
     * @uses TaxType::setCountry()
     * @uses TaxType::setCountrySubDivision()
     * @uses TaxType::setCurConversion()
     * @uses TaxType::setDescText()
     * @uses TaxType::setFiledAmount()
     * @uses TaxType::setFiledTaxCode()
     * @uses TaxType::setQualifierCode()
     * @uses TaxType::setRefundInd()
     * @uses TaxType::setTaxCode()
     * @uses TaxType::setTaxName()
     * @uses TaxType::setTaxTypeCode()
     * @param \StructType\AmountType $amount
     * @param string $addlFiledTaxCode
     * @param string $addlTaxCode
     * @param bool $approximateInd
     * @param string $appTypeCode
     * @param bool $collectionInd
     * @param \StructType\CollectionPointTax[] $collectionPointTax
     * @param \StructType\CountryType $country
     * @param \StructType\CountrySubDivision $countrySubDivision
     * @param \StructType\CurConversionType $curConversion
     * @param string $descText
     * @param \StructType\AmountType $filedAmount
     * @param string $filedTaxCode
     * @param string $qualifierCode
     * @param bool $refundInd
     * @param string $taxCode
     * @param string $taxName
     * @param string $taxTypeCode
     */
    public function __construct(\StructType\AmountType $amount = null, $addlFiledTaxCode = null, $addlTaxCode = null, $approximateInd = null, $appTypeCode = null, $collectionInd = null, array $collectionPointTax = array(), \StructType\CountryType $country = null, \StructType\CountrySubDivision $countrySubDivision = null, \StructType\CurConversionType $curConversion = null, $descText = null, \StructType\AmountType $filedAmount = null, $filedTaxCode = null, $qualifierCode = null, $refundInd = null, $taxCode = null, $taxName = null, $taxTypeCode = null)
    {
        $this
            ->setAmount($amount)
            ->setAddlFiledTaxCode($addlFiledTaxCode)
            ->setAddlTaxCode($addlTaxCode)
            ->setApproximateInd($approximateInd)
            ->setAppTypeCode($appTypeCode)
            ->setCollectionInd($collectionInd)
            ->setCollectionPointTax($collectionPointTax)
            ->setCountry($country)
            ->setCountrySubDivision($countrySubDivision)
            ->setCurConversion($curConversion)
            ->setDescText($descText)
            ->setFiledAmount($filedAmount)
            ->setFiledTaxCode($filedTaxCode)
            ->setQualifierCode($qualifierCode)
            ->setRefundInd($refundInd)
            ->setTaxCode($taxCode)
            ->setTaxName($taxName)
            ->setTaxTypeCode($taxTypeCode);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\TaxType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AddlFiledTaxCode value
     * @return string|null
     */
    public function getAddlFiledTaxCode()
    {
        return $this->AddlFiledTaxCode;
    }
    /**
     * Set AddlFiledTaxCode value
     * @param string $addlFiledTaxCode
     * @return \StructType\TaxType
     */
    public function setAddlFiledTaxCode($addlFiledTaxCode = null)
    {
        // validation for constraint: string
        if (!is_null($addlFiledTaxCode) && !is_string($addlFiledTaxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addlFiledTaxCode, true), gettype($addlFiledTaxCode)), __LINE__);
        }
        $this->AddlFiledTaxCode = $addlFiledTaxCode;
        return $this;
    }
    /**
     * Get AddlTaxCode value
     * @return string|null
     */
    public function getAddlTaxCode()
    {
        return $this->AddlTaxCode;
    }
    /**
     * Set AddlTaxCode value
     * @param string $addlTaxCode
     * @return \StructType\TaxType
     */
    public function setAddlTaxCode($addlTaxCode = null)
    {
        // validation for constraint: string
        if (!is_null($addlTaxCode) && !is_string($addlTaxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addlTaxCode, true), gettype($addlTaxCode)), __LINE__);
        }
        $this->AddlTaxCode = $addlTaxCode;
        return $this;
    }
    /**
     * Get ApproximateInd value
     * @return bool|null
     */
    public function getApproximateInd()
    {
        return $this->ApproximateInd;
    }
    /**
     * Set ApproximateInd value
     * @param bool $approximateInd
     * @return \StructType\TaxType
     */
    public function setApproximateInd($approximateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approximateInd) && !is_bool($approximateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approximateInd, true), gettype($approximateInd)), __LINE__);
        }
        $this->ApproximateInd = $approximateInd;
        return $this;
    }
    /**
     * Get AppTypeCode value
     * @return string|null
     */
    public function getAppTypeCode()
    {
        return $this->AppTypeCode;
    }
    /**
     * Set AppTypeCode value
     * @param string $appTypeCode
     * @return \StructType\TaxType
     */
    public function setAppTypeCode($appTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($appTypeCode) && !is_string($appTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appTypeCode, true), gettype($appTypeCode)), __LINE__);
        }
        $this->AppTypeCode = $appTypeCode;
        return $this;
    }
    /**
     * Get CollectionInd value
     * @return bool|null
     */
    public function getCollectionInd()
    {
        return $this->CollectionInd;
    }
    /**
     * Set CollectionInd value
     * @param bool $collectionInd
     * @return \StructType\TaxType
     */
    public function setCollectionInd($collectionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($collectionInd) && !is_bool($collectionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($collectionInd, true), gettype($collectionInd)), __LINE__);
        }
        $this->CollectionInd = $collectionInd;
        return $this;
    }
    /**
     * Get CollectionPointTax value
     * @return \StructType\CollectionPointTax[]|null
     */
    public function getCollectionPointTax()
    {
        return $this->CollectionPointTax;
    }
    /**
     * This method is responsible for validating the values passed to the setCollectionPointTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCollectionPointTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCollectionPointTaxForArrayConstraintsFromSetCollectionPointTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxTypeCollectionPointTaxItem) {
            // validation for constraint: itemType
            if (!$taxTypeCollectionPointTaxItem instanceof \StructType\CollectionPointTax) {
                $invalidValues[] = is_object($taxTypeCollectionPointTaxItem) ? get_class($taxTypeCollectionPointTaxItem) : sprintf('%s(%s)', gettype($taxTypeCollectionPointTaxItem), var_export($taxTypeCollectionPointTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CollectionPointTax property can only contain items of type \StructType\CollectionPointTax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CollectionPointTax value
     * @throws \InvalidArgumentException
     * @param \StructType\CollectionPointTax[] $collectionPointTax
     * @return \StructType\TaxType
     */
    public function setCollectionPointTax(array $collectionPointTax = array())
    {
        // validation for constraint: array
        if ('' !== ($collectionPointTaxArrayErrorMessage = self::validateCollectionPointTaxForArrayConstraintsFromSetCollectionPointTax($collectionPointTax))) {
            throw new \InvalidArgumentException($collectionPointTaxArrayErrorMessage, __LINE__);
        }
        $this->CollectionPointTax = $collectionPointTax;
        return $this;
    }
    /**
     * Add item to CollectionPointTax value
     * @throws \InvalidArgumentException
     * @param \StructType\CollectionPointTax $item
     * @return \StructType\TaxType
     */
    public function addToCollectionPointTax(\StructType\CollectionPointTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CollectionPointTax) {
            throw new \InvalidArgumentException(sprintf('The CollectionPointTax property can only contain items of type \StructType\CollectionPointTax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CollectionPointTax[] = $item;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CountryType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountryType $country
     * @return \StructType\TaxType
     */
    public function setCountry(\StructType\CountryType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountrySubDivision value
     * @return \StructType\CountrySubDivision|null
     */
    public function getCountrySubDivision()
    {
        return $this->CountrySubDivision;
    }
    /**
     * Set CountrySubDivision value
     * @param \StructType\CountrySubDivision $countrySubDivision
     * @return \StructType\TaxType
     */
    public function setCountrySubDivision(\StructType\CountrySubDivision $countrySubDivision = null)
    {
        $this->CountrySubDivision = $countrySubDivision;
        return $this;
    }
    /**
     * Get CurConversion value
     * @return \StructType\CurConversionType|null
     */
    public function getCurConversion()
    {
        return $this->CurConversion;
    }
    /**
     * Set CurConversion value
     * @param \StructType\CurConversionType $curConversion
     * @return \StructType\TaxType
     */
    public function setCurConversion(\StructType\CurConversionType $curConversion = null)
    {
        $this->CurConversion = $curConversion;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\TaxType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get FiledAmount value
     * @return \StructType\AmountType|null
     */
    public function getFiledAmount()
    {
        return $this->FiledAmount;
    }
    /**
     * Set FiledAmount value
     * @param \StructType\AmountType $filedAmount
     * @return \StructType\TaxType
     */
    public function setFiledAmount(\StructType\AmountType $filedAmount = null)
    {
        $this->FiledAmount = $filedAmount;
        return $this;
    }
    /**
     * Get FiledTaxCode value
     * @return string|null
     */
    public function getFiledTaxCode()
    {
        return $this->FiledTaxCode;
    }
    /**
     * Set FiledTaxCode value
     * @param string $filedTaxCode
     * @return \StructType\TaxType
     */
    public function setFiledTaxCode($filedTaxCode = null)
    {
        // validation for constraint: string
        if (!is_null($filedTaxCode) && !is_string($filedTaxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filedTaxCode, true), gettype($filedTaxCode)), __LINE__);
        }
        $this->FiledTaxCode = $filedTaxCode;
        return $this;
    }
    /**
     * Get QualifierCode value
     * @return string|null
     */
    public function getQualifierCode()
    {
        return $this->QualifierCode;
    }
    /**
     * Set QualifierCode value
     * @param string $qualifierCode
     * @return \StructType\TaxType
     */
    public function setQualifierCode($qualifierCode = null)
    {
        // validation for constraint: string
        if (!is_null($qualifierCode) && !is_string($qualifierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualifierCode, true), gettype($qualifierCode)), __LINE__);
        }
        $this->QualifierCode = $qualifierCode;
        return $this;
    }
    /**
     * Get RefundInd value
     * @return bool|null
     */
    public function getRefundInd()
    {
        return $this->RefundInd;
    }
    /**
     * Set RefundInd value
     * @param bool $refundInd
     * @return \StructType\TaxType
     */
    public function setRefundInd($refundInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundInd) && !is_bool($refundInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundInd, true), gettype($refundInd)), __LINE__);
        }
        $this->RefundInd = $refundInd;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\TaxType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->TaxName;
    }
    /**
     * Set TaxName value
     * @param string $taxName
     * @return \StructType\TaxType
     */
    public function setTaxName($taxName = null)
    {
        // validation for constraint: string
        if (!is_null($taxName) && !is_string($taxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxName, true), gettype($taxName)), __LINE__);
        }
        $this->TaxName = $taxName;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \StructType\TaxType
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeCode, true), gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
}
