<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax break down information group
 * @subpackage Structs
 */
class Tax extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Individual tax amount. Example: 2500
     * - use: required
     * @var int
     */
    public $Amount;
    /**
     * The Designator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Designator
     * @var string
     */
    public $Designator;
    /**
     * The Nature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Nature
     * @var string
     */
    public $Nature;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Description
     * @var string
     */
    public $Description;
    /**
     * The CollectionPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CollectionPoint[]
     */
    public $CollectionPoint;
    /**
     * Constructor method for Tax
     * @uses Tax::setAmount()
     * @uses Tax::setDesignator()
     * @uses Tax::setNature()
     * @uses Tax::setDescription()
     * @uses Tax::setCollectionPoint()
     * @param int $amount
     * @param string $designator
     * @param string $nature
     * @param string $description
     * @param \StructType\CollectionPoint[] $collectionPoint
     */
    public function __construct($amount = null, $designator = null, $nature = null, $description = null, array $collectionPoint = array())
    {
        $this
            ->setAmount($amount)
            ->setDesignator($designator)
            ->setNature($nature)
            ->setDescription($description)
            ->setCollectionPoint($collectionPoint);
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\Tax
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Designator value
     * @return string|null
     */
    public function getDesignator()
    {
        return $this->Designator;
    }
    /**
     * Set Designator value
     * @param string $designator
     * @return \StructType\Tax
     */
    public function setDesignator($designator = null)
    {
        // validation for constraint: string
        if (!is_null($designator) && !is_string($designator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designator, true), gettype($designator)), __LINE__);
        }
        $this->Designator = $designator;
        return $this;
    }
    /**
     * Get Nature value
     * @return string|null
     */
    public function getNature()
    {
        return $this->Nature;
    }
    /**
     * Set Nature value
     * @param string $nature
     * @return \StructType\Tax
     */
    public function setNature($nature = null)
    {
        // validation for constraint: string
        if (!is_null($nature) && !is_string($nature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nature, true), gettype($nature)), __LINE__);
        }
        $this->Nature = $nature;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Tax
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CollectionPoint value
     * @return \StructType\CollectionPoint[]|null
     */
    public function getCollectionPoint()
    {
        return $this->CollectionPoint;
    }
    /**
     * This method is responsible for validating the values passed to the setCollectionPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCollectionPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCollectionPointForArrayConstraintsFromSetCollectionPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxCollectionPointItem) {
            // validation for constraint: itemType
            if (!$taxCollectionPointItem instanceof \StructType\CollectionPoint) {
                $invalidValues[] = is_object($taxCollectionPointItem) ? get_class($taxCollectionPointItem) : sprintf('%s(%s)', gettype($taxCollectionPointItem), var_export($taxCollectionPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CollectionPoint property can only contain items of type \StructType\CollectionPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CollectionPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\CollectionPoint[] $collectionPoint
     * @return \StructType\Tax
     */
    public function setCollectionPoint(array $collectionPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($collectionPointArrayErrorMessage = self::validateCollectionPointForArrayConstraintsFromSetCollectionPoint($collectionPoint))) {
            throw new \InvalidArgumentException($collectionPointArrayErrorMessage, __LINE__);
        }
        $this->CollectionPoint = $collectionPoint;
        return $this;
    }
    /**
     * Add item to CollectionPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\CollectionPoint $item
     * @return \StructType\Tax
     */
    public function addToCollectionPoint(\StructType\CollectionPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CollectionPoint) {
            throw new \InvalidArgumentException(sprintf('The CollectionPoint property can only contain items of type \StructType\CollectionPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CollectionPoint[] = $item;
        return $this;
    }
}
