<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurchargesType StructType
 * @subpackage Structs
 */
class SurchargesType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Total surcharges amount. Example: 2000
     * - use: required
     * @var int
     */
    public $Amount;
    /**
     * The Surcharge
     * Meta information extracted from the WSDL
     * - documentation: Surcharges break down information.
     * - maxOccurs: unbounded
     * @var \StructType\SurchargeType[]
     */
    public $Surcharge;
    /**
     * Constructor method for SurchargesType
     * @uses SurchargesType::setAmount()
     * @uses SurchargesType::setSurcharge()
     * @param int $amount
     * @param \StructType\SurchargeType[] $surcharge
     */
    public function __construct($amount = null, array $surcharge = array())
    {
        $this
            ->setAmount($amount)
            ->setSurcharge($surcharge);
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\SurchargesType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Surcharge value
     * @return \StructType\SurchargeType[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * This method is responsible for validating the values passed to the setSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurchargeForArrayConstraintsFromSetSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surchargesTypeSurchargeItem) {
            // validation for constraint: itemType
            if (!$surchargesTypeSurchargeItem instanceof \StructType\SurchargeType) {
                $invalidValues[] = is_object($surchargesTypeSurchargeItem) ? get_class($surchargesTypeSurchargeItem) : sprintf('%s(%s)', gettype($surchargesTypeSurchargeItem), var_export($surchargesTypeSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType[] $surcharge
     * @return \StructType\SurchargesType
     */
    public function setSurcharge(array $surcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($surchargeArrayErrorMessage = self::validateSurchargeForArrayConstraintsFromSetSurcharge($surcharge))) {
            throw new \InvalidArgumentException($surchargeArrayErrorMessage, __LINE__);
        }
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType $item
     * @return \StructType\SurchargesType
     */
    public function addToSurcharge(\StructType\SurchargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SurchargeType) {
            throw new \InvalidArgumentException(sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Surcharge[] = $item;
        return $this;
    }
}
