<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierOrderedServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Supplier Ordered Service specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of
 * shopping, a service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class SupplierOrderedServiceType extends AbstractStructBase
{
    /**
     * The OrderedServiceAssociation
     * Meta information extracted from the WSDL
     * - documentation: Supplier Ordered Service Association
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderedServiceAssociationType
     */
    public $OrderedServiceAssociation;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The PaxSegmentReferences
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefListType
     */
    public $PaxSegmentReferences;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The ResponsibleAirline
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ResponsibleAirline;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to another service instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceRefID;
    /**
     * The SettlementConditionCode
     * Meta information extracted from the WSDL
     * - documentation: either 'Immediate' or 'Delivery' | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementConditionCode;
    /**
     * The SettlementTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: A date/time by which settlement must occur. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementTimeLimitDateTime;
    /**
     * The SettlementValue
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupplierPriceType
     */
    public $SettlementValue;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Service Status instance. See ATSB Codeset OrderService for possible values. | The possible statuses of an Order Service {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Service
     * Status,coded{/codeListName} {codeListIdentifier}ORDERSERVICE{/codeListIdentifier} | represents the statuses of an Order Service
     * - base: OrderServiceStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The UnchangedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicated that this service is unchanged after reshopping. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UnchangedInd;
    /**
     * Constructor method for SupplierOrderedServiceType
     * @uses SupplierOrderedServiceType::setOrderedServiceAssociation()
     * @uses SupplierOrderedServiceType::setPaxRefID()
     * @uses SupplierOrderedServiceType::setPaxSegmentReferences()
     * @uses SupplierOrderedServiceType::setServiceID()
     * @uses SupplierOrderedServiceType::setAirlineTaxonomy()
     * @uses SupplierOrderedServiceType::setBookingRef()
     * @uses SupplierOrderedServiceType::setResponsibleAirline()
     * @uses SupplierOrderedServiceType::setServiceRefID()
     * @uses SupplierOrderedServiceType::setSettlementConditionCode()
     * @uses SupplierOrderedServiceType::setSettlementTimeLimitDateTime()
     * @uses SupplierOrderedServiceType::setSettlementValue()
     * @uses SupplierOrderedServiceType::setStatusCode()
     * @uses SupplierOrderedServiceType::setUnchangedInd()
     * @param \StructType\OrderedServiceAssociationType $orderedServiceAssociation
     * @param string $paxRefID
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     * @param string $serviceID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\BookingRefType[] $bookingRef
     * @param \StructType\CarrierType $responsibleAirline
     * @param string $serviceRefID
     * @param string $settlementConditionCode
     * @param string $settlementTimeLimitDateTime
     * @param \StructType\SupplierPriceType $settlementValue
     * @param string $statusCode
     * @param bool $unchangedInd
     */
    public function __construct(\StructType\OrderedServiceAssociationType $orderedServiceAssociation = null, $paxRefID = null, \StructType\PaxSegmentRefListType $paxSegmentReferences = null, $serviceID = null, array $airlineTaxonomy = array(), array $bookingRef = array(), \StructType\CarrierType $responsibleAirline = null, $serviceRefID = null, $settlementConditionCode = null, $settlementTimeLimitDateTime = null, \StructType\SupplierPriceType $settlementValue = null, $statusCode = null, $unchangedInd = null)
    {
        $this
            ->setOrderedServiceAssociation($orderedServiceAssociation)
            ->setPaxRefID($paxRefID)
            ->setPaxSegmentReferences($paxSegmentReferences)
            ->setServiceID($serviceID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setBookingRef($bookingRef)
            ->setResponsibleAirline($responsibleAirline)
            ->setServiceRefID($serviceRefID)
            ->setSettlementConditionCode($settlementConditionCode)
            ->setSettlementTimeLimitDateTime($settlementTimeLimitDateTime)
            ->setSettlementValue($settlementValue)
            ->setStatusCode($statusCode)
            ->setUnchangedInd($unchangedInd);
    }
    /**
     * Get OrderedServiceAssociation value
     * @return \StructType\OrderedServiceAssociationType
     */
    public function getOrderedServiceAssociation()
    {
        return $this->OrderedServiceAssociation;
    }
    /**
     * Set OrderedServiceAssociation value
     * @param \StructType\OrderedServiceAssociationType $orderedServiceAssociation
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setOrderedServiceAssociation(\StructType\OrderedServiceAssociationType $orderedServiceAssociation = null)
    {
        $this->OrderedServiceAssociation = $orderedServiceAssociation;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get PaxSegmentReferences value
     * @return \StructType\PaxSegmentRefListType
     */
    public function getPaxSegmentReferences()
    {
        return $this->PaxSegmentReferences;
    }
    /**
     * Set PaxSegmentReferences value
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setPaxSegmentReferences(\StructType\PaxSegmentRefListType $paxSegmentReferences = null)
    {
        $this->PaxSegmentReferences = $paxSegmentReferences;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderedServiceTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$supplierOrderedServiceTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($supplierOrderedServiceTypeAirlineTaxonomyItem) ? get_class($supplierOrderedServiceTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($supplierOrderedServiceTypeAirlineTaxonomyItem), var_export($supplierOrderedServiceTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\SupplierOrderedServiceType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderedServiceTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$supplierOrderedServiceTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($supplierOrderedServiceTypeBookingRefItem) ? get_class($supplierOrderedServiceTypeBookingRefItem) : sprintf('%s(%s)', gettype($supplierOrderedServiceTypeBookingRefItem), var_export($supplierOrderedServiceTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($bookingRef) && count($bookingRef) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($bookingRef)), __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\SupplierOrderedServiceType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BookingRef) && count($this->BookingRef) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BookingRef)), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get ResponsibleAirline value
     * @return \StructType\CarrierType|null
     */
    public function getResponsibleAirline()
    {
        return $this->ResponsibleAirline;
    }
    /**
     * Set ResponsibleAirline value
     * @param \StructType\CarrierType $responsibleAirline
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setResponsibleAirline(\StructType\CarrierType $responsibleAirline = null)
    {
        $this->ResponsibleAirline = $responsibleAirline;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get SettlementConditionCode value
     * @return string|null
     */
    public function getSettlementConditionCode()
    {
        return $this->SettlementConditionCode;
    }
    /**
     * Set SettlementConditionCode value
     * @param string $settlementConditionCode
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setSettlementConditionCode($settlementConditionCode = null)
    {
        // validation for constraint: string
        if (!is_null($settlementConditionCode) && !is_string($settlementConditionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementConditionCode, true), gettype($settlementConditionCode)), __LINE__);
        }
        $this->SettlementConditionCode = $settlementConditionCode;
        return $this;
    }
    /**
     * Get SettlementTimeLimitDateTime value
     * @return string|null
     */
    public function getSettlementTimeLimitDateTime()
    {
        return $this->SettlementTimeLimitDateTime;
    }
    /**
     * Set SettlementTimeLimitDateTime value
     * @param string $settlementTimeLimitDateTime
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setSettlementTimeLimitDateTime($settlementTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($settlementTimeLimitDateTime) && !is_string($settlementTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementTimeLimitDateTime, true), gettype($settlementTimeLimitDateTime)), __LINE__);
        }
        $this->SettlementTimeLimitDateTime = $settlementTimeLimitDateTime;
        return $this;
    }
    /**
     * Get SettlementValue value
     * @return \StructType\SupplierPriceType|null
     */
    public function getSettlementValue()
    {
        return $this->SettlementValue;
    }
    /**
     * Set SettlementValue value
     * @param \StructType\SupplierPriceType $settlementValue
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setSettlementValue(\StructType\SupplierPriceType $settlementValue = null)
    {
        $this->SettlementValue = $settlementValue;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get UnchangedInd value
     * @return bool|null
     */
    public function getUnchangedInd()
    {
        return $this->UnchangedInd;
    }
    /**
     * Set UnchangedInd value
     * @param bool $unchangedInd
     * @return \StructType\SupplierOrderedServiceType
     */
    public function setUnchangedInd($unchangedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($unchangedInd) && !is_bool($unchangedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unchangedInd, true), gettype($unchangedInd)), __LINE__);
        }
        $this->UnchangedInd = $unchangedInd;
        return $this;
    }
}
