<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopOverRestrictionsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional information supplied by the Airline for the current Itinerary to advise the Seller that additional options could be available (if the Seller changes the request) to add Stop Overs within the itinerary.
 * @subpackage Structs
 */
class StopOverRestrictionsType extends AbstractStructBase
{
    /**
     * The AvailInd
     * Meta information extracted from the WSDL
     * - documentation: Boolean to signify that Stop Overs are possible, and could be searched for on this itinerary. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AvailInd;
    /**
     * The ChargeableInd
     * Meta information extracted from the WSDL
     * - documentation: An indicator to identify if the Stopover has an associated fee. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ChargeableInd;
    /**
     * The MaximumStopOversPermittedQty
     * Meta information extracted from the WSDL
     * - documentation: If Stop overs are available, this element places an optional limit to the number of stopovers that can be added to the itinerary. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MaximumStopOversPermittedQty;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Used to store a ref to the passenger. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * The StopOverLocation
     * Meta information extracted from the WSDL
     * - documentation: Container to describe where a Stop Over can be added into an Itinerary. The Stop Over location is tied to the Arrival Port of the referenced Pax Segment (or Pax Leg) referenced and contains the maximum time permitted at that stop.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StopOverLocationType[]
     */
    public $StopOverLocation;
    /**
     * Constructor method for StopOverRestrictionsType
     * @uses StopOverRestrictionsType::setAvailInd()
     * @uses StopOverRestrictionsType::setChargeableInd()
     * @uses StopOverRestrictionsType::setMaximumStopOversPermittedQty()
     * @uses StopOverRestrictionsType::setPaxRefID()
     * @uses StopOverRestrictionsType::setStopOverLocation()
     * @param bool $availInd
     * @param bool $chargeableInd
     * @param float $maximumStopOversPermittedQty
     * @param string $paxRefID
     * @param \StructType\StopOverLocationType[] $stopOverLocation
     */
    public function __construct($availInd = null, $chargeableInd = null, $maximumStopOversPermittedQty = null, $paxRefID = null, array $stopOverLocation = array())
    {
        $this
            ->setAvailInd($availInd)
            ->setChargeableInd($chargeableInd)
            ->setMaximumStopOversPermittedQty($maximumStopOversPermittedQty)
            ->setPaxRefID($paxRefID)
            ->setStopOverLocation($stopOverLocation);
    }
    /**
     * Get AvailInd value
     * @return bool|null
     */
    public function getAvailInd()
    {
        return $this->AvailInd;
    }
    /**
     * Set AvailInd value
     * @param bool $availInd
     * @return \StructType\StopOverRestrictionsType
     */
    public function setAvailInd($availInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($availInd) && !is_bool($availInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availInd, true), gettype($availInd)), __LINE__);
        }
        $this->AvailInd = $availInd;
        return $this;
    }
    /**
     * Get ChargeableInd value
     * @return bool|null
     */
    public function getChargeableInd()
    {
        return $this->ChargeableInd;
    }
    /**
     * Set ChargeableInd value
     * @param bool $chargeableInd
     * @return \StructType\StopOverRestrictionsType
     */
    public function setChargeableInd($chargeableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargeableInd) && !is_bool($chargeableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chargeableInd, true), gettype($chargeableInd)), __LINE__);
        }
        $this->ChargeableInd = $chargeableInd;
        return $this;
    }
    /**
     * Get MaximumStopOversPermittedQty value
     * @return float|null
     */
    public function getMaximumStopOversPermittedQty()
    {
        return $this->MaximumStopOversPermittedQty;
    }
    /**
     * Set MaximumStopOversPermittedQty value
     * @param float $maximumStopOversPermittedQty
     * @return \StructType\StopOverRestrictionsType
     */
    public function setMaximumStopOversPermittedQty($maximumStopOversPermittedQty = null)
    {
        // validation for constraint: float
        if (!is_null($maximumStopOversPermittedQty) && !(is_float($maximumStopOversPermittedQty) || is_numeric($maximumStopOversPermittedQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumStopOversPermittedQty, true), gettype($maximumStopOversPermittedQty)), __LINE__);
        }
        $this->MaximumStopOversPermittedQty = $maximumStopOversPermittedQty;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\StopOverRestrictionsType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get StopOverLocation value
     * @return \StructType\StopOverLocationType[]|null
     */
    public function getStopOverLocation()
    {
        return $this->StopOverLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setStopOverLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStopOverLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStopOverLocationForArrayConstraintsFromSetStopOverLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stopOverRestrictionsTypeStopOverLocationItem) {
            // validation for constraint: itemType
            if (!$stopOverRestrictionsTypeStopOverLocationItem instanceof \StructType\StopOverLocationType) {
                $invalidValues[] = is_object($stopOverRestrictionsTypeStopOverLocationItem) ? get_class($stopOverRestrictionsTypeStopOverLocationItem) : sprintf('%s(%s)', gettype($stopOverRestrictionsTypeStopOverLocationItem), var_export($stopOverRestrictionsTypeStopOverLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StopOverLocation property can only contain items of type \StructType\StopOverLocationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StopOverLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\StopOverLocationType[] $stopOverLocation
     * @return \StructType\StopOverRestrictionsType
     */
    public function setStopOverLocation(array $stopOverLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($stopOverLocationArrayErrorMessage = self::validateStopOverLocationForArrayConstraintsFromSetStopOverLocation($stopOverLocation))) {
            throw new \InvalidArgumentException($stopOverLocationArrayErrorMessage, __LINE__);
        }
        $this->StopOverLocation = $stopOverLocation;
        return $this;
    }
    /**
     * Add item to StopOverLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\StopOverLocationType $item
     * @return \StructType\StopOverRestrictionsType
     */
    public function addToStopOverLocation(\StructType\StopOverLocationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StopOverLocationType) {
            throw new \InvalidArgumentException(sprintf('The StopOverLocation property can only contain items of type \StructType\StopOverLocationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StopOverLocation[] = $item;
        return $this;
    }
}
