<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayPeriodType StructType
 * Meta information extracted from the WSDL
 * - documentation: Time constraints for an Affinity Shopping request including specific Dates, Seasons, Months, or Durations.
 * @subpackage Structs
 */
class StayPeriodType extends AbstractStructBase
{
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - documentation: Ending date of the stay period. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The MaximumStayDuration
     * Meta information extracted from the WSDL
     * - documentation: Maximum stay period within the specified date or calendar range. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and
     * Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaximumStayDuration;
    /**
     * The MinimumStayDuration
     * Meta information extracted from the WSDL
     * - documentation: Minimum stay period within the specified date or calendar range. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and
     * Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinimumStayDuration;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - documentation: Starting Date of the stay period. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * Constructor method for StayPeriodType
     * @uses StayPeriodType::setEndDate()
     * @uses StayPeriodType::setMaximumStayDuration()
     * @uses StayPeriodType::setMinimumStayDuration()
     * @uses StayPeriodType::setStartDate()
     * @param string $endDate
     * @param string $maximumStayDuration
     * @param string $minimumStayDuration
     * @param string $startDate
     */
    public function __construct($endDate = null, $maximumStayDuration = null, $minimumStayDuration = null, $startDate = null)
    {
        $this
            ->setEndDate($endDate)
            ->setMaximumStayDuration($maximumStayDuration)
            ->setMinimumStayDuration($minimumStayDuration)
            ->setStartDate($startDate);
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\StayPeriodType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get MaximumStayDuration value
     * @return string|null
     */
    public function getMaximumStayDuration()
    {
        return $this->MaximumStayDuration;
    }
    /**
     * Set MaximumStayDuration value
     * @param string $maximumStayDuration
     * @return \StructType\StayPeriodType
     */
    public function setMaximumStayDuration($maximumStayDuration = null)
    {
        // validation for constraint: string
        if (!is_null($maximumStayDuration) && !is_string($maximumStayDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumStayDuration, true), gettype($maximumStayDuration)), __LINE__);
        }
        $this->MaximumStayDuration = $maximumStayDuration;
        return $this;
    }
    /**
     * Get MinimumStayDuration value
     * @return string|null
     */
    public function getMinimumStayDuration()
    {
        return $this->MinimumStayDuration;
    }
    /**
     * Set MinimumStayDuration value
     * @param string $minimumStayDuration
     * @return \StructType\StayPeriodType
     */
    public function setMinimumStayDuration($minimumStayDuration = null)
    {
        // validation for constraint: string
        if (!is_null($minimumStayDuration) && !is_string($minimumStayDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumStayDuration, true), gettype($minimumStayDuration)), __LINE__);
        }
        $this->MinimumStayDuration = $minimumStayDuration;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\StayPeriodType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
}
