<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Station StructType
 * Meta information extracted from the WSDL
 * - documentation: Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off. Those of relevance to the airline industry are identified by an IATA Location
 * Identifier (3 letter location identifier). There are also additional airports without an IATA identifier that may be used in disruption scenarios that will be identified by an ICAO 4 letter code (assigned to every registered airport, military or
 * civil). Business Identifier Fields: - IATA Location Code
 * @subpackage Structs
 */
class Station extends AbstractStructBase
{
    /**
     * The IATA_LocationCode
     * Meta information extracted from the WSDL
     * - documentation: IATA 3-letter code defining the city or airport code.
     * - base: xs:string
     * - length: 3
     * @var string
     */
    public $IATA_LocationCode;
    /**
     * The StationName
     * Meta information extracted from the WSDL
     * - documentation: Name of the station. E.g. George Bush Intercontinental Airport.
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $StationName;
    /**
     * Constructor method for Station
     * @uses Station::setIATA_LocationCode()
     * @uses Station::setStationName()
     * @param string $iATA_LocationCode
     * @param string $stationName
     */
    public function __construct($iATA_LocationCode = null, $stationName = null)
    {
        $this
            ->setIATA_LocationCode($iATA_LocationCode)
            ->setStationName($stationName);
    }
    /**
     * Get IATA_LocationCode value
     * @return string|null
     */
    public function getIATA_LocationCode()
    {
        return $this->IATA_LocationCode;
    }
    /**
     * Set IATA_LocationCode value
     * @param string $iATA_LocationCode
     * @return \StructType\Station
     */
    public function setIATA_LocationCode($iATA_LocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_LocationCode) && !is_string($iATA_LocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_LocationCode, true), gettype($iATA_LocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($iATA_LocationCode) && mb_strlen($iATA_LocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($iATA_LocationCode)), __LINE__);
        }
        $this->IATA_LocationCode = $iATA_LocationCode;
        return $this;
    }
    /**
     * Get StationName value
     * @return string|null
     */
    public function getStationName()
    {
        return $this->StationName;
    }
    /**
     * Set StationName value
     * @param string $stationName
     * @return \StructType\Station
     */
    public function setStationName($stationName = null)
    {
        // validation for constraint: string
        if (!is_null($stationName) && !is_string($stationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stationName, true), gettype($stationName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($stationName) && mb_strlen($stationName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($stationName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($stationName) && mb_strlen($stationName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($stationName)), __LINE__);
        }
        $this->StationName = $stationName;
        return $this;
    }
}
