<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceListType StructType
 * Meta information extracted from the WSDL
 * - documentation: List of Special service types. Technical object only
 * @subpackage Structs
 */
class SpecialServiceListType extends AbstractStructBase
{
    /**
     * The SpecialService
     * Meta information extracted from the WSDL
     * - documentation: Special service information
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SpecialServiceType[]
     */
    public $SpecialService;
    /**
     * Constructor method for SpecialServiceListType
     * @uses SpecialServiceListType::setSpecialService()
     * @param \StructType\SpecialServiceType[] $specialService
     */
    public function __construct(array $specialService = array())
    {
        $this
            ->setSpecialService($specialService);
    }
    /**
     * Get SpecialService value
     * @return \StructType\SpecialServiceType[]
     */
    public function getSpecialService()
    {
        return $this->SpecialService;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialServiceForArrayConstraintsFromSetSpecialService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialServiceListTypeSpecialServiceItem) {
            // validation for constraint: itemType
            if (!$specialServiceListTypeSpecialServiceItem instanceof \StructType\SpecialServiceType) {
                $invalidValues[] = is_object($specialServiceListTypeSpecialServiceItem) ? get_class($specialServiceListTypeSpecialServiceItem) : sprintf('%s(%s)', gettype($specialServiceListTypeSpecialServiceItem), var_export($specialServiceListTypeSpecialServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialService property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialService value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType[] $specialService
     * @return \StructType\SpecialServiceListType
     */
    public function setSpecialService(array $specialService = array())
    {
        // validation for constraint: array
        if ('' !== ($specialServiceArrayErrorMessage = self::validateSpecialServiceForArrayConstraintsFromSetSpecialService($specialService))) {
            throw new \InvalidArgumentException($specialServiceArrayErrorMessage, __LINE__);
        }
        $this->SpecialService = $specialService;
        return $this;
    }
    /**
     * Add item to SpecialService value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType $item
     * @return \StructType\SpecialServiceListType
     */
    public function addToSpecialService(\StructType\SpecialServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialServiceType) {
            throw new \InvalidArgumentException(sprintf('The SpecialService property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialService[] = $item;
        return $this;
    }
}
