<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingRequestPaxSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
 * @subpackage Structs
 */
class ShoppingRequestPaxSegmentType extends AbstractStructBase
{
    /**
     * The CabinTypeAssociationChoice
     * Meta information extracted from the WSDL
     * - documentation: A choice of Cabin Type Association to leg(s) or a segment
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CabinTypeAssociationChoiceType
     */
    public $CabinTypeAssociationChoice;
    /**
     * The DatedMarketingSegmentRefId
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique identifier of a dated marketing segment used in a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatedMarketingSegmentRefId;
    /**
     * The PaxSegmentID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Segment within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxSegmentID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareBasisCode;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The SettlementInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementInfoType
     */
    public $SettlementInfo;
    /**
     * Constructor method for ShoppingRequestPaxSegmentType
     * @uses ShoppingRequestPaxSegmentType::setCabinTypeAssociationChoice()
     * @uses ShoppingRequestPaxSegmentType::setDatedMarketingSegmentRefId()
     * @uses ShoppingRequestPaxSegmentType::setPaxSegmentID()
     * @uses ShoppingRequestPaxSegmentType::setAirlineTaxonomy()
     * @uses ShoppingRequestPaxSegmentType::setFareBasisCode()
     * @uses ShoppingRequestPaxSegmentType::setRichMedia()
     * @uses ShoppingRequestPaxSegmentType::setSettlementInfo()
     * @param \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice
     * @param string $datedMarketingSegmentRefId
     * @param string $paxSegmentID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param string[] $fareBasisCode
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param \StructType\SettlementInfoType $settlementInfo
     */
    public function __construct(\StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice = null, $datedMarketingSegmentRefId = null, $paxSegmentID = null, array $airlineTaxonomy = array(), array $fareBasisCode = array(), array $richMedia = array(), \StructType\SettlementInfoType $settlementInfo = null)
    {
        $this
            ->setCabinTypeAssociationChoice($cabinTypeAssociationChoice)
            ->setDatedMarketingSegmentRefId($datedMarketingSegmentRefId)
            ->setPaxSegmentID($paxSegmentID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setFareBasisCode($fareBasisCode)
            ->setRichMedia($richMedia)
            ->setSettlementInfo($settlementInfo);
    }
    /**
     * Get CabinTypeAssociationChoice value
     * @return \StructType\CabinTypeAssociationChoiceType
     */
    public function getCabinTypeAssociationChoice()
    {
        return $this->CabinTypeAssociationChoice;
    }
    /**
     * Set CabinTypeAssociationChoice value
     * @param \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function setCabinTypeAssociationChoice(\StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice = null)
    {
        $this->CabinTypeAssociationChoice = $cabinTypeAssociationChoice;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentRefId value
     * @return string
     */
    public function getDatedMarketingSegmentRefId()
    {
        return $this->DatedMarketingSegmentRefId;
    }
    /**
     * Set DatedMarketingSegmentRefId value
     * @param string $datedMarketingSegmentRefId
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function setDatedMarketingSegmentRefId($datedMarketingSegmentRefId = null)
    {
        // validation for constraint: string
        if (!is_null($datedMarketingSegmentRefId) && !is_string($datedMarketingSegmentRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedMarketingSegmentRefId, true), gettype($datedMarketingSegmentRefId)), __LINE__);
        }
        $this->DatedMarketingSegmentRefId = $datedMarketingSegmentRefId;
        return $this;
    }
    /**
     * Get PaxSegmentID value
     * @return string
     */
    public function getPaxSegmentID()
    {
        return $this->PaxSegmentID;
    }
    /**
     * Set PaxSegmentID value
     * @param string $paxSegmentID
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function setPaxSegmentID($paxSegmentID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentID) && !is_string($paxSegmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentID, true), gettype($paxSegmentID)), __LINE__);
        }
        $this->PaxSegmentID = $paxSegmentID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingRequestPaxSegmentTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$shoppingRequestPaxSegmentTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($shoppingRequestPaxSegmentTypeAirlineTaxonomyItem) ? get_class($shoppingRequestPaxSegmentTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($shoppingRequestPaxSegmentTypeAirlineTaxonomyItem), var_export($shoppingRequestPaxSegmentTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string[]|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * This method is responsible for validating the values passed to the setFareBasisCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareBasisCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingRequestPaxSegmentTypeFareBasisCodeItem) {
            // validation for constraint: itemType
            if (!is_string($shoppingRequestPaxSegmentTypeFareBasisCodeItem)) {
                $invalidValues[] = is_object($shoppingRequestPaxSegmentTypeFareBasisCodeItem) ? get_class($shoppingRequestPaxSegmentTypeFareBasisCodeItem) : sprintf('%s(%s)', gettype($shoppingRequestPaxSegmentTypeFareBasisCodeItem), var_export($shoppingRequestPaxSegmentTypeFareBasisCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareBasisCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string[] $fareBasisCode
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function setFareBasisCode(array $fareBasisCode = array())
    {
        // validation for constraint: array
        if ('' !== ($fareBasisCodeArrayErrorMessage = self::validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode($fareBasisCode))) {
            throw new \InvalidArgumentException($fareBasisCodeArrayErrorMessage, __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Add item to FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function addToFareBasisCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FareBasisCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareBasisCode[] = $item;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingRequestPaxSegmentTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$shoppingRequestPaxSegmentTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($shoppingRequestPaxSegmentTypeRichMediaItem) ? get_class($shoppingRequestPaxSegmentTypeRichMediaItem) : sprintf('%s(%s)', gettype($shoppingRequestPaxSegmentTypeRichMediaItem), var_export($shoppingRequestPaxSegmentTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get SettlementInfo value
     * @return \StructType\SettlementInfoType|null
     */
    public function getSettlementInfo()
    {
        return $this->SettlementInfo;
    }
    /**
     * Set SettlementInfo value
     * @param \StructType\SettlementInfoType $settlementInfo
     * @return \StructType\ShoppingRequestPaxSegmentType
     */
    public function setSettlementInfo(\StructType\SettlementInfoType $settlementInfo = null)
    {
        $this->SettlementInfo = $settlementInfo;
        return $this;
    }
}
