<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingRequestPaxSegmentListType StructType
 * Meta information extracted from the WSDL
 * - documentation: A shopping request specialization of a Passenger Segment data list definition.
 * @subpackage Structs
 */
class ShoppingRequestPaxSegmentListType extends AbstractStructBase
{
    /**
     * The PaxSegment
     * Meta information extracted from the WSDL
     * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ShoppingRequestPaxSegmentType[]
     */
    public $PaxSegment;
    /**
     * Constructor method for ShoppingRequestPaxSegmentListType
     * @uses ShoppingRequestPaxSegmentListType::setPaxSegment()
     * @param \StructType\ShoppingRequestPaxSegmentType[] $paxSegment
     */
    public function __construct(array $paxSegment = array())
    {
        $this
            ->setPaxSegment($paxSegment);
    }
    /**
     * Get PaxSegment value
     * @return \StructType\ShoppingRequestPaxSegmentType[]
     */
    public function getPaxSegment()
    {
        return $this->PaxSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentForArrayConstraintsFromSetPaxSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingRequestPaxSegmentListTypePaxSegmentItem) {
            // validation for constraint: itemType
            if (!$shoppingRequestPaxSegmentListTypePaxSegmentItem instanceof \StructType\ShoppingRequestPaxSegmentType) {
                $invalidValues[] = is_object($shoppingRequestPaxSegmentListTypePaxSegmentItem) ? get_class($shoppingRequestPaxSegmentListTypePaxSegmentItem) : sprintf('%s(%s)', gettype($shoppingRequestPaxSegmentListTypePaxSegmentItem), var_export($shoppingRequestPaxSegmentListTypePaxSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegment property can only contain items of type \StructType\ShoppingRequestPaxSegmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestPaxSegmentType[] $paxSegment
     * @return \StructType\ShoppingRequestPaxSegmentListType
     */
    public function setPaxSegment(array $paxSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentArrayErrorMessage = self::validatePaxSegmentForArrayConstraintsFromSetPaxSegment($paxSegment))) {
            throw new \InvalidArgumentException($paxSegmentArrayErrorMessage, __LINE__);
        }
        $this->PaxSegment = $paxSegment;
        return $this;
    }
    /**
     * Add item to PaxSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestPaxSegmentType $item
     * @return \StructType\ShoppingRequestPaxSegmentListType
     */
    public function addToPaxSegment(\StructType\ShoppingRequestPaxSegmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingRequestPaxSegmentType) {
            throw new \InvalidArgumentException(sprintf('The PaxSegment property can only contain items of type \StructType\ShoppingRequestPaxSegmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegment[] = $item;
        return $this;
    }
}
