<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingRequestPaxJourneyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Shopping Request specialization of Passenger Journey Generic type definition A collection of segments which satisfies transportation of a passenger for a given origin and destination. Business Identifier Fields: - (no identifier
 * available)
 * @subpackage Structs
 */
class ShoppingRequestPaxJourneyType extends AbstractStructBase
{
    /**
     * The PaxJourneyID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Journey within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxJourneyID;
    /**
     * The PaxSegment
     * Meta information extracted from the WSDL
     * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ShopandReshopRequestPaxSegmentType[]
     */
    public $PaxSegment;
    /**
     * Constructor method for ShoppingRequestPaxJourneyType
     * @uses ShoppingRequestPaxJourneyType::setPaxJourneyID()
     * @uses ShoppingRequestPaxJourneyType::setPaxSegment()
     * @param string $paxJourneyID
     * @param \StructType\ShopandReshopRequestPaxSegmentType[] $paxSegment
     */
    public function __construct($paxJourneyID = null, array $paxSegment = array())
    {
        $this
            ->setPaxJourneyID($paxJourneyID)
            ->setPaxSegment($paxSegment);
    }
    /**
     * Get PaxJourneyID value
     * @return string
     */
    public function getPaxJourneyID()
    {
        return $this->PaxJourneyID;
    }
    /**
     * Set PaxJourneyID value
     * @param string $paxJourneyID
     * @return \StructType\ShoppingRequestPaxJourneyType
     */
    public function setPaxJourneyID($paxJourneyID = null)
    {
        // validation for constraint: string
        if (!is_null($paxJourneyID) && !is_string($paxJourneyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxJourneyID, true), gettype($paxJourneyID)), __LINE__);
        }
        $this->PaxJourneyID = $paxJourneyID;
        return $this;
    }
    /**
     * Get PaxSegment value
     * @return \StructType\ShopandReshopRequestPaxSegmentType[]
     */
    public function getPaxSegment()
    {
        return $this->PaxSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentForArrayConstraintsFromSetPaxSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingRequestPaxJourneyTypePaxSegmentItem) {
            // validation for constraint: itemType
            if (!$shoppingRequestPaxJourneyTypePaxSegmentItem instanceof \StructType\ShopandReshopRequestPaxSegmentType) {
                $invalidValues[] = is_object($shoppingRequestPaxJourneyTypePaxSegmentItem) ? get_class($shoppingRequestPaxJourneyTypePaxSegmentItem) : sprintf('%s(%s)', gettype($shoppingRequestPaxJourneyTypePaxSegmentItem), var_export($shoppingRequestPaxJourneyTypePaxSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegment property can only contain items of type \StructType\ShopandReshopRequestPaxSegmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\ShopandReshopRequestPaxSegmentType[] $paxSegment
     * @return \StructType\ShoppingRequestPaxJourneyType
     */
    public function setPaxSegment(array $paxSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentArrayErrorMessage = self::validatePaxSegmentForArrayConstraintsFromSetPaxSegment($paxSegment))) {
            throw new \InvalidArgumentException($paxSegmentArrayErrorMessage, __LINE__);
        }
        $this->PaxSegment = $paxSegment;
        return $this;
    }
    /**
     * Add item to PaxSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\ShopandReshopRequestPaxSegmentType $item
     * @return \StructType\ShoppingRequestPaxJourneyType
     */
    public function addToPaxSegment(\StructType\ShopandReshopRequestPaxSegmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShopandReshopRequestPaxSegmentType) {
            throw new \InvalidArgumentException(sprintf('The PaxSegment property can only contain items of type \StructType\ShopandReshopRequestPaxSegmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegment[] = $item;
        return $this;
    }
}
