<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingRequestPaxJourneyListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Journey data list definition.
 * @subpackage Structs
 */
class ShoppingRequestPaxJourneyListType extends AbstractStructBase
{
    /**
     * The PaxJourney
     * Meta information extracted from the WSDL
     * - documentation: Shopping Request specialization of Passenger Journey Generic type definition A collection of segments which satisfies transportation of a passenger for a given origin and destination. Business Identifier Fields: - (no identifier
     * available)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShoppingRequestPaxJourneyType[]
     */
    public $PaxJourney;
    /**
     * Constructor method for ShoppingRequestPaxJourneyListType
     * @uses ShoppingRequestPaxJourneyListType::setPaxJourney()
     * @param \StructType\ShoppingRequestPaxJourneyType[] $paxJourney
     */
    public function __construct(array $paxJourney = array())
    {
        $this
            ->setPaxJourney($paxJourney);
    }
    /**
     * Get PaxJourney value
     * @return \StructType\ShoppingRequestPaxJourneyType[]|null
     */
    public function getPaxJourney()
    {
        return $this->PaxJourney;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxJourney method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxJourney method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxJourneyForArrayConstraintsFromSetPaxJourney(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shoppingRequestPaxJourneyListTypePaxJourneyItem) {
            // validation for constraint: itemType
            if (!$shoppingRequestPaxJourneyListTypePaxJourneyItem instanceof \StructType\ShoppingRequestPaxJourneyType) {
                $invalidValues[] = is_object($shoppingRequestPaxJourneyListTypePaxJourneyItem) ? get_class($shoppingRequestPaxJourneyListTypePaxJourneyItem) : sprintf('%s(%s)', gettype($shoppingRequestPaxJourneyListTypePaxJourneyItem), var_export($shoppingRequestPaxJourneyListTypePaxJourneyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxJourney property can only contain items of type \StructType\ShoppingRequestPaxJourneyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestPaxJourneyType[] $paxJourney
     * @return \StructType\ShoppingRequestPaxJourneyListType
     */
    public function setPaxJourney(array $paxJourney = array())
    {
        // validation for constraint: array
        if ('' !== ($paxJourneyArrayErrorMessage = self::validatePaxJourneyForArrayConstraintsFromSetPaxJourney($paxJourney))) {
            throw new \InvalidArgumentException($paxJourneyArrayErrorMessage, __LINE__);
        }
        $this->PaxJourney = $paxJourney;
        return $this;
    }
    /**
     * Add item to PaxJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestPaxJourneyType $item
     * @return \StructType\ShoppingRequestPaxJourneyListType
     */
    public function addToPaxJourney(\StructType\ShoppingRequestPaxJourneyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingRequestPaxJourneyType) {
            throw new \InvalidArgumentException(sprintf('The PaxJourney property can only contain items of type \StructType\ShoppingRequestPaxJourneyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxJourney[] = $item;
        return $this;
    }
}
