<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingRequestCabinTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Shopping Request specialisation of Cabin Type base type definition: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
 * @subpackage Structs
 */
class ShoppingRequestCabinTypeType extends AbstractStructBase
{
    /**
     * The CabinTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Cabin Type Code as defined by PADIS codeset 9873 (e.g. 1,2,3 etc) | Specifies the Cabin Type Code as defined by ATSB codeset 9873 {codeListAgencyName}ATSB{/codeListAgencyName} {codeListName}Cabin class of service,
     * coded{/codeListName} {codeListIdentifier}9873{/codeListIdentifier} | Additional BDT to specify the Cabin Type Code as defined by PADIS.
     * - base: CabinTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CabinTypeCode;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for ShoppingRequestCabinTypeType
     * @uses ShoppingRequestCabinTypeType::setCabinTypeCode()
     * @uses ShoppingRequestCabinTypeType::setPrefLevel()
     * @param string $cabinTypeCode
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct($cabinTypeCode = null, \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setCabinTypeCode($cabinTypeCode)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get CabinTypeCode value
     * @return string
     */
    public function getCabinTypeCode()
    {
        return $this->CabinTypeCode;
    }
    /**
     * Set CabinTypeCode value
     * @param string $cabinTypeCode
     * @return \StructType\ShoppingRequestCabinTypeType
     */
    public function setCabinTypeCode($cabinTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cabinTypeCode) && !is_string($cabinTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinTypeCode, true), gettype($cabinTypeCode)), __LINE__);
        }
        $this->CabinTypeCode = $cabinTypeCode;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\ShoppingRequestCabinTypeType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
