<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopandReshopRequestPaxSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
 * @subpackage Structs
 */
class ShopandReshopRequestPaxSegmentType extends AbstractStructBase
{
    /**
     * The DatedMarketingSegmentRefId
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique identifier of a dated marketing segment used in a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatedMarketingSegmentRefId;
    /**
     * The PaxSegmentID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Segment within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxSegmentID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The CabinTypeAssociationChoice
     * Meta information extracted from the WSDL
     * - documentation: A choice of Cabin Type Association to leg(s) or a segment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeAssociationChoiceType
     */
    public $CabinTypeAssociationChoice;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The SettlementInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementInfoType
     */
    public $SettlementInfo;
    /**
     * Constructor method for ShopandReshopRequestPaxSegmentType
     * @uses ShopandReshopRequestPaxSegmentType::setDatedMarketingSegmentRefId()
     * @uses ShopandReshopRequestPaxSegmentType::setPaxSegmentID()
     * @uses ShopandReshopRequestPaxSegmentType::setAirlineTaxonomy()
     * @uses ShopandReshopRequestPaxSegmentType::setCabinTypeAssociationChoice()
     * @uses ShopandReshopRequestPaxSegmentType::setRichMedia()
     * @uses ShopandReshopRequestPaxSegmentType::setSettlementInfo()
     * @param string $datedMarketingSegmentRefId
     * @param string $paxSegmentID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param \StructType\SettlementInfoType $settlementInfo
     */
    public function __construct($datedMarketingSegmentRefId = null, $paxSegmentID = null, array $airlineTaxonomy = array(), \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice = null, array $richMedia = array(), \StructType\SettlementInfoType $settlementInfo = null)
    {
        $this
            ->setDatedMarketingSegmentRefId($datedMarketingSegmentRefId)
            ->setPaxSegmentID($paxSegmentID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setCabinTypeAssociationChoice($cabinTypeAssociationChoice)
            ->setRichMedia($richMedia)
            ->setSettlementInfo($settlementInfo);
    }
    /**
     * Get DatedMarketingSegmentRefId value
     * @return string
     */
    public function getDatedMarketingSegmentRefId()
    {
        return $this->DatedMarketingSegmentRefId;
    }
    /**
     * Set DatedMarketingSegmentRefId value
     * @param string $datedMarketingSegmentRefId
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function setDatedMarketingSegmentRefId($datedMarketingSegmentRefId = null)
    {
        // validation for constraint: string
        if (!is_null($datedMarketingSegmentRefId) && !is_string($datedMarketingSegmentRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedMarketingSegmentRefId, true), gettype($datedMarketingSegmentRefId)), __LINE__);
        }
        $this->DatedMarketingSegmentRefId = $datedMarketingSegmentRefId;
        return $this;
    }
    /**
     * Get PaxSegmentID value
     * @return string
     */
    public function getPaxSegmentID()
    {
        return $this->PaxSegmentID;
    }
    /**
     * Set PaxSegmentID value
     * @param string $paxSegmentID
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function setPaxSegmentID($paxSegmentID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentID) && !is_string($paxSegmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentID, true), gettype($paxSegmentID)), __LINE__);
        }
        $this->PaxSegmentID = $paxSegmentID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shopandReshopRequestPaxSegmentTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$shopandReshopRequestPaxSegmentTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($shopandReshopRequestPaxSegmentTypeAirlineTaxonomyItem) ? get_class($shopandReshopRequestPaxSegmentTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($shopandReshopRequestPaxSegmentTypeAirlineTaxonomyItem), var_export($shopandReshopRequestPaxSegmentTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get CabinTypeAssociationChoice value
     * @return \StructType\CabinTypeAssociationChoiceType|null
     */
    public function getCabinTypeAssociationChoice()
    {
        return $this->CabinTypeAssociationChoice;
    }
    /**
     * Set CabinTypeAssociationChoice value
     * @param \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function setCabinTypeAssociationChoice(\StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice = null)
    {
        $this->CabinTypeAssociationChoice = $cabinTypeAssociationChoice;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shopandReshopRequestPaxSegmentTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$shopandReshopRequestPaxSegmentTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($shopandReshopRequestPaxSegmentTypeRichMediaItem) ? get_class($shopandReshopRequestPaxSegmentTypeRichMediaItem) : sprintf('%s(%s)', gettype($shopandReshopRequestPaxSegmentTypeRichMediaItem), var_export($shopandReshopRequestPaxSegmentTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get SettlementInfo value
     * @return \StructType\SettlementInfoType|null
     */
    public function getSettlementInfo()
    {
        return $this->SettlementInfo;
    }
    /**
     * Set SettlementInfo value
     * @param \StructType\SettlementInfoType $settlementInfo
     * @return \StructType\ShopandReshopRequestPaxSegmentType
     */
    public function setSettlementInfo(\StructType\SettlementInfoType $settlementInfo = null)
    {
        $this->SettlementInfo = $settlementInfo;
        return $this;
    }
}
