<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettlementPlanType StructType
 * Meta information extracted from the WSDL
 * - documentation: Any payment that is collected by the agent and settled between the Airline and the agent. Refer to IATA Resolution 728 Attachment A for full details.
 * @subpackage Structs
 */
class SettlementPlanType extends AbstractStructBase
{
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The payment method type. Examples: Credit Card, Cash. | The form of payment type. Examples: Credit Card, Cash. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Form of payment identification{/codeListName}
     * {codeListIdentifier}9888{/codeListIdentifier} | Additional BDT to specify payment method code.
     * - base: PaymentMethodCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The IATA_Number
     * Meta information extracted from the WSDL
     * - documentation: IATA-assigned agency number. Example: 98417900 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $IATA_Number;
    /**
     * Constructor method for SettlementPlanType
     * @uses SettlementPlanType::setPaymentTypeCode()
     * @uses SettlementPlanType::setIATA_Number()
     * @param string $paymentTypeCode
     * @param float $iATA_Number
     */
    public function __construct($paymentTypeCode = null, $iATA_Number = null)
    {
        $this
            ->setPaymentTypeCode($paymentTypeCode)
            ->setIATA_Number($iATA_Number);
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\SettlementPlanType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get IATA_Number value
     * @return float|null
     */
    public function getIATA_Number()
    {
        return $this->IATA_Number;
    }
    /**
     * Set IATA_Number value
     * @param float $iATA_Number
     * @return \StructType\SettlementPlanType
     */
    public function setIATA_Number($iATA_Number = null)
    {
        // validation for constraint: float
        if (!is_null($iATA_Number) && !(is_float($iATA_Number) || is_numeric($iATA_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iATA_Number, true), gettype($iATA_Number)), __LINE__);
        }
        $this->IATA_Number = $iATA_Number;
        return $this;
    }
}
