<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceListOfferRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a request using offers
 * @subpackage Structs
 */
class ServiceListOfferRequestType extends AbstractStructBase
{
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - documentation: This is a specialized offer used in the context of a Shopping Request. **TO BE MERGED in common type work** Generic offer definition is: A proposal to sell a specific set of products or Services under specific conditions, for a
     * certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main
     * purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a
     * scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ServiceListOfferType[]
     */
    public $Offer;
    /**
     * Constructor method for ServiceListOfferRequestType
     * @uses ServiceListOfferRequestType::setOffer()
     * @param \StructType\ServiceListOfferType[] $offer
     */
    public function __construct(array $offer = array())
    {
        $this
            ->setOffer($offer);
    }
    /**
     * Get Offer value
     * @return \StructType\ServiceListOfferType[]
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListOfferRequestTypeOfferItem) {
            // validation for constraint: itemType
            if (!$serviceListOfferRequestTypeOfferItem instanceof \StructType\ServiceListOfferType) {
                $invalidValues[] = is_object($serviceListOfferRequestTypeOfferItem) ? get_class($serviceListOfferRequestTypeOfferItem) : sprintf('%s(%s)', gettype($serviceListOfferRequestTypeOfferItem), var_export($serviceListOfferRequestTypeOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\ServiceListOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceListOfferType[] $offer
     * @return \StructType\ServiceListOfferRequestType
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceListOfferType $item
     * @return \StructType\ServiceListOfferRequestType
     */
    public function addToOffer(\StructType\ServiceListOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceListOfferType) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\ServiceListOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
}
