<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Service filter criteria specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping,
 * a service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class ServiceFilterCriteriaType extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The DeliveryStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Service Delivery Service Status instance. See ATSB Codeset DeliveryService for possible values. | Shows the possible statuses of a service delivery item. {codeListAgencyName}IATA Code List{/codeListAgencyName}
     * {codeListName}Delivery Service Status, Coded.{/codeListName} {codeListIdentifier}DELIVERYSERVICE{/codeListIdentifier} | Represents the current status of a service delivery item
     * - base: ServiceDeliveryStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryStatusCode;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Free text for textual description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The InventoryGuaranteeDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time inventory against a given Service is guaranteed. If inventory is not guaranteed, the Order creation (or change) may fail. In the absence of a time limit, no inventory is guaranteed. Notes: The presence of an
     * inventory guarantee does not assume a guarantee of price. For the price to be guaranteed against a given Offer Item, the Price Guarantee Time Limit must also be present. The assumption is that inventory is held when an Order is created (or changed),
     * so this time limit only applies in the context of an Offer. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InventoryGuaranteeDateTime;
    /**
     * The UnchangedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicated that this service is unchanged after reshopping. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UnchangedInd;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for ServiceFilterCriteriaType
     * @uses ServiceFilterCriteriaType::setServiceID()
     * @uses ServiceFilterCriteriaType::setBookingRef()
     * @uses ServiceFilterCriteriaType::setDeliveryStatusCode()
     * @uses ServiceFilterCriteriaType::setDescText()
     * @uses ServiceFilterCriteriaType::setInventoryGuaranteeDateTime()
     * @uses ServiceFilterCriteriaType::setUnchangedInd()
     * @uses ServiceFilterCriteriaType::setValidatingCarrier()
     * @param string $serviceID
     * @param \StructType\BookingRefType[] $bookingRef
     * @param string $deliveryStatusCode
     * @param string $descText
     * @param string $inventoryGuaranteeDateTime
     * @param bool $unchangedInd
     * @param \StructType\CarrierType $validatingCarrier
     */
    public function __construct($serviceID = null, array $bookingRef = array(), $deliveryStatusCode = null, $descText = null, $inventoryGuaranteeDateTime = null, $unchangedInd = null, \StructType\CarrierType $validatingCarrier = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setBookingRef($bookingRef)
            ->setDeliveryStatusCode($deliveryStatusCode)
            ->setDescText($descText)
            ->setInventoryGuaranteeDateTime($inventoryGuaranteeDateTime)
            ->setUnchangedInd($unchangedInd)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceFilterCriteriaTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$serviceFilterCriteriaTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($serviceFilterCriteriaTypeBookingRefItem) ? get_class($serviceFilterCriteriaTypeBookingRefItem) : sprintf('%s(%s)', gettype($serviceFilterCriteriaTypeBookingRefItem), var_export($serviceFilterCriteriaTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($bookingRef) && count($bookingRef) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($bookingRef)), __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BookingRef) && count($this->BookingRef) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BookingRef)), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get DeliveryStatusCode value
     * @return string|null
     */
    public function getDeliveryStatusCode()
    {
        return $this->DeliveryStatusCode;
    }
    /**
     * Set DeliveryStatusCode value
     * @param string $deliveryStatusCode
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function setDeliveryStatusCode($deliveryStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStatusCode) && !is_string($deliveryStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStatusCode, true), gettype($deliveryStatusCode)), __LINE__);
        }
        $this->DeliveryStatusCode = $deliveryStatusCode;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get InventoryGuaranteeDateTime value
     * @return string|null
     */
    public function getInventoryGuaranteeDateTime()
    {
        return $this->InventoryGuaranteeDateTime;
    }
    /**
     * Set InventoryGuaranteeDateTime value
     * @param string $inventoryGuaranteeDateTime
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function setInventoryGuaranteeDateTime($inventoryGuaranteeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryGuaranteeDateTime) && !is_string($inventoryGuaranteeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryGuaranteeDateTime, true), gettype($inventoryGuaranteeDateTime)), __LINE__);
        }
        $this->InventoryGuaranteeDateTime = $inventoryGuaranteeDateTime;
        return $this;
    }
    /**
     * Get UnchangedInd value
     * @return bool|null
     */
    public function getUnchangedInd()
    {
        return $this->UnchangedInd;
    }
    /**
     * Set UnchangedInd value
     * @param bool $unchangedInd
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function setUnchangedInd($unchangedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($unchangedInd) && !is_bool($unchangedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unchangedInd, true), gettype($unchangedInd)), __LINE__);
        }
        $this->UnchangedInd = $unchangedInd;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \StructType\CarrierType $validatingCarrier
     * @return \StructType\ServiceFilterCriteriaType
     */
    public function setValidatingCarrier(\StructType\CarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
}
