<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDeliveryRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Service Delivery Request content for message
 * @subpackage Structs
 */
class ServiceDeliveryRequestType extends AbstractStructBase
{
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType
     */
    public $DatedOperatingSegmentList;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderKeyType
     */
    public $Order;
    /**
     * The Pax
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxType[]
     */
    public $Pax;
    /**
     * The PaxSegment
     * Meta information extracted from the WSDL
     * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentType
     */
    public $PaxSegment;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Delivered Service is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold
     * to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeliveredServiceType
     */
    public $Service;
    /**
     * Constructor method for ServiceDeliveryRequestType
     * @uses ServiceDeliveryRequestType::setContactInfoList()
     * @uses ServiceDeliveryRequestType::setDatedMarketingSegmentList()
     * @uses ServiceDeliveryRequestType::setDatedOperatingLegList()
     * @uses ServiceDeliveryRequestType::setDatedOperatingSegmentList()
     * @uses ServiceDeliveryRequestType::setOrder()
     * @uses ServiceDeliveryRequestType::setPax()
     * @uses ServiceDeliveryRequestType::setPaxSegment()
     * @uses ServiceDeliveryRequestType::setService()
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @param \StructType\OrderKeyType $order
     * @param \StructType\PaxType[] $pax
     * @param \StructType\PaxSegmentType $paxSegment
     * @param \StructType\DeliveredServiceType $service
     */
    public function __construct(array $contactInfoList = array(), \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null, \StructType\DatedOperatingLegListType $datedOperatingLegList = null, \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null, \StructType\OrderKeyType $order = null, array $pax = array(), \StructType\PaxSegmentType $paxSegment = null, \StructType\DeliveredServiceType $service = null)
    {
        $this
            ->setContactInfoList($contactInfoList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setOrder($order)
            ->setPax($pax)
            ->setPaxSegment($paxSegment)
            ->setService($service);
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDeliveryRequestTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$serviceDeliveryRequestTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($serviceDeliveryRequestTypeContactInfoListItem) ? get_class($serviceDeliveryRequestTypeContactInfoListItem) : sprintf('%s(%s)', gettype($serviceDeliveryRequestTypeContactInfoListItem), var_export($serviceDeliveryRequestTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null)
    {
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * Set DatedOperatingLegList value
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setDatedOperatingLegList(\StructType\DatedOperatingLegListType $datedOperatingLegList = null)
    {
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null)
    {
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderKeyType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderKeyType $order
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setOrder(\StructType\OrderKeyType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Pax value
     * @return \StructType\PaxType[]|null
     */
    public function getPax()
    {
        return $this->Pax;
    }
    /**
     * This method is responsible for validating the values passed to the setPax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxForArrayConstraintsFromSetPax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDeliveryRequestTypePaxItem) {
            // validation for constraint: itemType
            if (!$serviceDeliveryRequestTypePaxItem instanceof \StructType\PaxType) {
                $invalidValues[] = is_object($serviceDeliveryRequestTypePaxItem) ? get_class($serviceDeliveryRequestTypePaxItem) : sprintf('%s(%s)', gettype($serviceDeliveryRequestTypePaxItem), var_export($serviceDeliveryRequestTypePaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType[] $pax
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setPax(array $pax = array())
    {
        // validation for constraint: array
        if ('' !== ($paxArrayErrorMessage = self::validatePaxForArrayConstraintsFromSetPax($pax))) {
            throw new \InvalidArgumentException($paxArrayErrorMessage, __LINE__);
        }
        $this->Pax = $pax;
        return $this;
    }
    /**
     * Add item to Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType $item
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function addToPax(\StructType\PaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxType) {
            throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pax[] = $item;
        return $this;
    }
    /**
     * Get PaxSegment value
     * @return \StructType\PaxSegmentType|null
     */
    public function getPaxSegment()
    {
        return $this->PaxSegment;
    }
    /**
     * Set PaxSegment value
     * @param \StructType\PaxSegmentType $paxSegment
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setPaxSegment(\StructType\PaxSegmentType $paxSegment = null)
    {
        $this->PaxSegment = $paxSegment;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\DeliveredServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\DeliveredServiceType $service
     * @return \StructType\ServiceDeliveryRequestType
     */
    public function setService(\StructType\DeliveredServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
}
