<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDefinitionListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Service Definition data list definition.
 * @subpackage Structs
 */
class ServiceDefinitionListType extends AbstractStructBase
{
    /**
     * The ServiceDefinition
     * Meta information extracted from the WSDL
     * - documentation: Description and characteristics of a non-flight product or service that can be separately sold and delivered. E.g. bag, seat, meal on a flight. Business Identifier Fields: - [Shopping Response] Shopping Response ID - [Carrier]
     * Airline Designator Code - Service Definition ID
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ServiceDefinitionType[]
     */
    public $ServiceDefinition;
    /**
     * Constructor method for ServiceDefinitionListType
     * @uses ServiceDefinitionListType::setServiceDefinition()
     * @param \StructType\ServiceDefinitionType[] $serviceDefinition
     */
    public function __construct(array $serviceDefinition = array())
    {
        $this
            ->setServiceDefinition($serviceDefinition);
    }
    /**
     * Get ServiceDefinition value
     * @return \StructType\ServiceDefinitionType[]
     */
    public function getServiceDefinition()
    {
        return $this->ServiceDefinition;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceDefinitionForArrayConstraintsFromSetServiceDefinition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDefinitionListTypeServiceDefinitionItem) {
            // validation for constraint: itemType
            if (!$serviceDefinitionListTypeServiceDefinitionItem instanceof \StructType\ServiceDefinitionType) {
                $invalidValues[] = is_object($serviceDefinitionListTypeServiceDefinitionItem) ? get_class($serviceDefinitionListTypeServiceDefinitionItem) : sprintf('%s(%s)', gettype($serviceDefinitionListTypeServiceDefinitionItem), var_export($serviceDefinitionListTypeServiceDefinitionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceDefinition property can only contain items of type \StructType\ServiceDefinitionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceDefinitionType[] $serviceDefinition
     * @return \StructType\ServiceDefinitionListType
     */
    public function setServiceDefinition(array $serviceDefinition = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceDefinitionArrayErrorMessage = self::validateServiceDefinitionForArrayConstraintsFromSetServiceDefinition($serviceDefinition))) {
            throw new \InvalidArgumentException($serviceDefinitionArrayErrorMessage, __LINE__);
        }
        $this->ServiceDefinition = $serviceDefinition;
        return $this;
    }
    /**
     * Add item to ServiceDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceDefinitionType $item
     * @return \StructType\ServiceDefinitionListType
     */
    public function addToServiceDefinition(\StructType\ServiceDefinitionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceDefinitionType) {
            throw new \InvalidArgumentException(sprintf('The ServiceDefinition property can only contain items of type \StructType\ServiceDefinitionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceDefinition[] = $item;
        return $this;
    }
}
