<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDefinitionAssociationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Service Definition Association Choice to determine if the information of this ServiceDefinition needs to be extended with specific Bag or Seat characteristics or whether the ServiceDefinition is used as a bundle of further
 * ServiceDefinitions.
 * @subpackage Structs
 */
class ServiceDefinitionAssociationType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Baggage Allowance
     * - choice: BaggageAllowanceRef | SeatProfileRef | ServiceBundle
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BaggageAllowanceRefType
     */
    public $BaggageAllowanceRef;
    /**
     * The SeatProfileRef
     * Meta information extracted from the WSDL
     * - documentation: Temp ABIE to Reference a Seat Profile Reference.
     * - choice: BaggageAllowanceRef | SeatProfileRef | ServiceBundle
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatProfileRefType
     */
    public $SeatProfileRef;
    /**
     * The ServiceBundle
     * Meta information extracted from the WSDL
     * - documentation: A set of services offered for sale as a single service.
     * - choice: BaggageAllowanceRef | SeatProfileRef | ServiceBundle
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceBundleType
     */
    public $ServiceBundle;
    /**
     * Constructor method for ServiceDefinitionAssociationType
     * @uses ServiceDefinitionAssociationType::setBaggageAllowanceRef()
     * @uses ServiceDefinitionAssociationType::setSeatProfileRef()
     * @uses ServiceDefinitionAssociationType::setServiceBundle()
     * @param \StructType\BaggageAllowanceRefType $baggageAllowanceRef
     * @param \StructType\SeatProfileRefType $seatProfileRef
     * @param \StructType\ServiceBundleType $serviceBundle
     */
    public function __construct(\StructType\BaggageAllowanceRefType $baggageAllowanceRef = null, \StructType\SeatProfileRefType $seatProfileRef = null, \StructType\ServiceBundleType $serviceBundle = null)
    {
        $this
            ->setBaggageAllowanceRef($baggageAllowanceRef)
            ->setSeatProfileRef($seatProfileRef)
            ->setServiceBundle($serviceBundle);
    }
    /**
     * Get BaggageAllowanceRef value
     * @return \StructType\BaggageAllowanceRefType
     */
    public function getBaggageAllowanceRef()
    {
        return isset($this->BaggageAllowanceRef) ? $this->BaggageAllowanceRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBaggageAllowanceRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageAllowanceRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBaggageAllowanceRefForChoiceConstraintsFromSetBaggageAllowanceRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SeatProfileRef',
            'ServiceBundle',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BaggageAllowanceRef can\'t be set as the property %s is already set. Only one property must be set among these properties: BaggageAllowanceRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BaggageAllowanceRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageAllowanceRefType $baggageAllowanceRef
     * @return \StructType\ServiceDefinitionAssociationType
     */
    public function setBaggageAllowanceRef(\StructType\BaggageAllowanceRefType $baggageAllowanceRef = null)
    {
        // validation for constraint: choice(BaggageAllowanceRef, SeatProfileRef, ServiceBundle)
        if ('' !== ($baggageAllowanceRefChoiceErrorMessage = self::validateBaggageAllowanceRefForChoiceConstraintsFromSetBaggageAllowanceRef($baggageAllowanceRef))) {
            throw new \InvalidArgumentException($baggageAllowanceRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($baggageAllowanceRef) || (is_array($baggageAllowanceRef) && empty($baggageAllowanceRef))) {
            unset($this->BaggageAllowanceRef);
        } else {
            $this->BaggageAllowanceRef = $baggageAllowanceRef;
        }
        return $this;
    }
    /**
     * Get SeatProfileRef value
     * @return \StructType\SeatProfileRefType
     */
    public function getSeatProfileRef()
    {
        return isset($this->SeatProfileRef) ? $this->SeatProfileRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeatProfileRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatProfileRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatProfileRefForChoiceConstraintsFromSetSeatProfileRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BaggageAllowanceRef',
            'ServiceBundle',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeatProfileRef can\'t be set as the property %s is already set. Only one property must be set among these properties: SeatProfileRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SeatProfileRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SeatProfileRefType $seatProfileRef
     * @return \StructType\ServiceDefinitionAssociationType
     */
    public function setSeatProfileRef(\StructType\SeatProfileRefType $seatProfileRef = null)
    {
        // validation for constraint: choice(BaggageAllowanceRef, SeatProfileRef, ServiceBundle)
        if ('' !== ($seatProfileRefChoiceErrorMessage = self::validateSeatProfileRefForChoiceConstraintsFromSetSeatProfileRef($seatProfileRef))) {
            throw new \InvalidArgumentException($seatProfileRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($seatProfileRef) || (is_array($seatProfileRef) && empty($seatProfileRef))) {
            unset($this->SeatProfileRef);
        } else {
            $this->SeatProfileRef = $seatProfileRef;
        }
        return $this;
    }
    /**
     * Get ServiceBundle value
     * @return \StructType\ServiceBundleType
     */
    public function getServiceBundle()
    {
        return isset($this->ServiceBundle) ? $this->ServiceBundle : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceBundle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceBundle method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceBundleForChoiceConstraintsFromSetServiceBundle($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BaggageAllowanceRef',
            'SeatProfileRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceBundle can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceBundle, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceBundle value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceBundleType $serviceBundle
     * @return \StructType\ServiceDefinitionAssociationType
     */
    public function setServiceBundle(\StructType\ServiceBundleType $serviceBundle = null)
    {
        // validation for constraint: choice(BaggageAllowanceRef, SeatProfileRef, ServiceBundle)
        if ('' !== ($serviceBundleChoiceErrorMessage = self::validateServiceBundleForChoiceConstraintsFromSetServiceBundle($serviceBundle))) {
            throw new \InvalidArgumentException($serviceBundleChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceBundle) || (is_array($serviceBundle) && empty($serviceBundle))) {
            unset($this->ServiceBundle);
        } else {
            $this->ServiceBundle = $serviceBundle;
        }
        return $this;
    }
}
