<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceBundleType StructType
 * Meta information extracted from the WSDL
 * - documentation: A set of services offered for sale as a single service.
 * @subpackage Structs
 */
class ServiceBundleType extends AbstractStructBase
{
    /**
     * The ServiceDefinitionRefID
     * Meta information extracted from the WSDL
     * - documentation: Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight | An identifier is a character string used to uniquely identify one instance of an
     * object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $ServiceDefinitionRefID;
    /**
     * The MaximumServiceQty
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of service definitions that may be selected from those in the bundle. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MaximumServiceQty;
    /**
     * Constructor method for ServiceBundleType
     * @uses ServiceBundleType::setServiceDefinitionRefID()
     * @uses ServiceBundleType::setMaximumServiceQty()
     * @param string[] $serviceDefinitionRefID
     * @param float $maximumServiceQty
     */
    public function __construct(array $serviceDefinitionRefID = array(), $maximumServiceQty = null)
    {
        $this
            ->setServiceDefinitionRefID($serviceDefinitionRefID)
            ->setMaximumServiceQty($maximumServiceQty);
    }
    /**
     * Get ServiceDefinitionRefID value
     * @return string[]
     */
    public function getServiceDefinitionRefID()
    {
        return $this->ServiceDefinitionRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceDefinitionRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinitionRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceDefinitionRefIDForArrayConstraintsFromSetServiceDefinitionRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceBundleTypeServiceDefinitionRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($serviceBundleTypeServiceDefinitionRefIDItem)) {
                $invalidValues[] = is_object($serviceBundleTypeServiceDefinitionRefIDItem) ? get_class($serviceBundleTypeServiceDefinitionRefIDItem) : sprintf('%s(%s)', gettype($serviceBundleTypeServiceDefinitionRefIDItem), var_export($serviceBundleTypeServiceDefinitionRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceDefinitionRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceDefinitionRefID value
     * @throws \InvalidArgumentException
     * @param string[] $serviceDefinitionRefID
     * @return \StructType\ServiceBundleType
     */
    public function setServiceDefinitionRefID(array $serviceDefinitionRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceDefinitionRefIDArrayErrorMessage = self::validateServiceDefinitionRefIDForArrayConstraintsFromSetServiceDefinitionRefID($serviceDefinitionRefID))) {
            throw new \InvalidArgumentException($serviceDefinitionRefIDArrayErrorMessage, __LINE__);
        }
        $this->ServiceDefinitionRefID = $serviceDefinitionRefID;
        return $this;
    }
    /**
     * Add item to ServiceDefinitionRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceBundleType
     */
    public function addToServiceDefinitionRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ServiceDefinitionRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceDefinitionRefID[] = $item;
        return $this;
    }
    /**
     * Get MaximumServiceQty value
     * @return float|null
     */
    public function getMaximumServiceQty()
    {
        return $this->MaximumServiceQty;
    }
    /**
     * Set MaximumServiceQty value
     * @param float $maximumServiceQty
     * @return \StructType\ServiceBundleType
     */
    public function setMaximumServiceQty($maximumServiceQty = null)
    {
        // validation for constraint: float
        if (!is_null($maximumServiceQty) && !(is_float($maximumServiceQty) || is_numeric($maximumServiceQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumServiceQty, true), gettype($maximumServiceQty)), __LINE__);
        }
        $this->MaximumServiceQty = $maximumServiceQty;
        return $this;
    }
}
