<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the list of order items selected.
 * @subpackage Structs
 */
class SelectedOrderItemType extends AbstractStructBase
{
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order Item ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $OrderItemRefID;
    /**
     * Constructor method for SelectedOrderItemType
     * @uses SelectedOrderItemType::setOrderItemRefID()
     * @param string[] $orderItemRefID
     */
    public function __construct(array $orderItemRefID = array())
    {
        $this
            ->setOrderItemRefID($orderItemRefID);
    }
    /**
     * Get OrderItemRefID value
     * @return string[]
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedOrderItemTypeOrderItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($selectedOrderItemTypeOrderItemRefIDItem)) {
                $invalidValues[] = is_object($selectedOrderItemTypeOrderItemRefIDItem) ? get_class($selectedOrderItemTypeOrderItemRefIDItem) : sprintf('%s(%s)', gettype($selectedOrderItemTypeOrderItemRefIDItem), var_export($selectedOrderItemTypeOrderItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string[] $orderItemRefID
     * @return \StructType\SelectedOrderItemType
     */
    public function setOrderItemRefID(array $orderItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemRefIDArrayErrorMessage = self::validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID($orderItemRefID))) {
            throw new \InvalidArgumentException($orderItemRefIDArrayErrorMessage, __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Add item to OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SelectedOrderItemType
     */
    public function addToOrderItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItemRefID[] = $item;
        return $this;
    }
}
