<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedALaCarteOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Use to select the quantity of Offer Items from the A La Carte Offer Items.
 * @subpackage Structs
 */
class SelectedALaCarteOfferItemType extends AbstractStructBase
{
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity to allow the ordering of more than one instances of the related a la carte OfferItem. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The OfferFlightAssociations
     * Meta information extracted from the WSDL
     * - documentation: Offer Flight Associations
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferFlightAssociationsType
     */
    public $OfferFlightAssociations;
    /**
     * Constructor method for SelectedALaCarteOfferItemType
     * @uses SelectedALaCarteOfferItemType::setQty()
     * @uses SelectedALaCarteOfferItemType::setOfferFlightAssociations()
     * @param float $qty
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     */
    public function __construct($qty = null, \StructType\OfferFlightAssociationsType $offerFlightAssociations = null)
    {
        $this
            ->setQty($qty)
            ->setOfferFlightAssociations($offerFlightAssociations);
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\SelectedALaCarteOfferItemType
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get OfferFlightAssociations value
     * @return \StructType\OfferFlightAssociationsType|null
     */
    public function getOfferFlightAssociations()
    {
        return $this->OfferFlightAssociations;
    }
    /**
     * Set OfferFlightAssociations value
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     * @return \StructType\SelectedALaCarteOfferItemType
     */
    public function setOfferFlightAssociations(\StructType\OfferFlightAssociationsType $offerFlightAssociations = null)
    {
        $this->OfferFlightAssociations = $offerFlightAssociations;
        return $this;
    }
}
