<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentDurationCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Total segment travel time preferences.
 * @subpackage Structs
 */
class SegmentDurationCriteriaType extends AbstractStructBase
{
    /**
     * The MaximumTimeMeasure
     * Meta information extracted from the WSDL
     * - documentation: Preferred maximum time for any Segment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $MaximumTimeMeasure;
    /**
     * The PrefCode
     * Meta information extracted from the WSDL
     * - documentation: Level of preference requested. Examples: Preferred, Required or Exclude.
     * - base: PrefLevelCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrefCode;
    /**
     * Constructor method for SegmentDurationCriteriaType
     * @uses SegmentDurationCriteriaType::setMaximumTimeMeasure()
     * @uses SegmentDurationCriteriaType::setPrefCode()
     * @param \StructType\MeasureType $maximumTimeMeasure
     * @param string $prefCode
     */
    public function __construct(\StructType\MeasureType $maximumTimeMeasure = null, $prefCode = null)
    {
        $this
            ->setMaximumTimeMeasure($maximumTimeMeasure)
            ->setPrefCode($prefCode);
    }
    /**
     * Get MaximumTimeMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getMaximumTimeMeasure()
    {
        return $this->MaximumTimeMeasure;
    }
    /**
     * Set MaximumTimeMeasure value
     * @param \StructType\MeasureType $maximumTimeMeasure
     * @return \StructType\SegmentDurationCriteriaType
     */
    public function setMaximumTimeMeasure(\StructType\MeasureType $maximumTimeMeasure = null)
    {
        $this->MaximumTimeMeasure = $maximumTimeMeasure;
        return $this;
    }
    /**
     * Get PrefCode value
     * @return string|null
     */
    public function getPrefCode()
    {
        return $this->PrefCode;
    }
    /**
     * Set PrefCode value
     * @param string $prefCode
     * @return \StructType\SegmentDurationCriteriaType
     */
    public function setPrefCode($prefCode = null)
    {
        // validation for constraint: string
        if (!is_null($prefCode) && !is_string($prefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefCode, true), gettype($prefCode)), __LINE__);
        }
        $this->PrefCode = $prefCode;
        return $this;
    }
}
