<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurePaymentVersion2Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all information for the result of 3D-Secure authentication process. Applicable to 3DS v2.0 and higher.
 * @subpackage Structs
 */
class SecurePaymentVersion2Type extends AbstractStructBase
{
    /**
     * The AuthenticationMerchantName
     * Meta information extracted from the WSDL
     * - documentation: Name of the merchant | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthenticationMerchantName;
    /**
     * The AuthenticationTokenValue
     * Meta information extracted from the WSDL
     * - documentation: Authentication value of a Token | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthenticationTokenValue;
    /**
     * The AuthenticationValue
     * Meta information extracted from the WSDL
     * - documentation: Authentication value | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthenticationValue;
    /**
     * The CardNumberCollectionCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the collection method of the card number. This will be newly entered or using previously saved information. This is supported by a enumerated list. | How the Card Number was collected.
     * - base: CardNumberCollectionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNumberCollectionCode;
    /**
     * The DirectoryServerTrxID
     * Meta information extracted from the WSDL
     * - documentation: DS (Directory Server) transaction ID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DirectoryServerTrxID;
    /**
     * The ElectronicCommerceInd
     * Meta information extracted from the WSDL
     * - documentation: ECI (electronic commerce indicator) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ElectronicCommerceInd;
    /**
     * The PayerAuthenticationExemptionCode
     * Meta information extracted from the WSDL
     * - documentation: Used to identify an exemption to performing payer authentication. An enumeration includes the types of exemption. | Types of payer authentication exemptions
     * - base: PayerAuthenticationExemptionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerAuthenticationExemptionCode;
    /**
     * The PayerAuthenticationFailureToCompleteCode
     * Meta information extracted from the WSDL
     * - documentation: Used to identify possible pre defined reasons for failure to complete payer authentication. | Types of failure to complete payer authentication
     * - base: PayerAuthenticationFailureToCompleteCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerAuthenticationFailureToCompleteCode;
    /**
     * The PaymentTrxChannelCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the payment transaction channel | Payment transaction channels
     * - base: PaymentTrxChannelCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTrxChannelCode;
    /**
     * The ProgramProtocolText
     * Meta information extracted from the WSDL
     * - documentation: Program Protocol | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramProtocolText;
    /**
     * The TrxStatusText
     * Meta information extracted from the WSDL
     * - documentation: outcome of authentication - see EMVCO documentation | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TrxStatusText;
    /**
     * Constructor method for SecurePaymentVersion2Type
     * @uses SecurePaymentVersion2Type::setAuthenticationMerchantName()
     * @uses SecurePaymentVersion2Type::setAuthenticationTokenValue()
     * @uses SecurePaymentVersion2Type::setAuthenticationValue()
     * @uses SecurePaymentVersion2Type::setCardNumberCollectionCode()
     * @uses SecurePaymentVersion2Type::setDirectoryServerTrxID()
     * @uses SecurePaymentVersion2Type::setElectronicCommerceInd()
     * @uses SecurePaymentVersion2Type::setPayerAuthenticationExemptionCode()
     * @uses SecurePaymentVersion2Type::setPayerAuthenticationFailureToCompleteCode()
     * @uses SecurePaymentVersion2Type::setPaymentTrxChannelCode()
     * @uses SecurePaymentVersion2Type::setProgramProtocolText()
     * @uses SecurePaymentVersion2Type::setTrxStatusText()
     * @param string $authenticationMerchantName
     * @param string $authenticationTokenValue
     * @param string $authenticationValue
     * @param string $cardNumberCollectionCode
     * @param string $directoryServerTrxID
     * @param string $electronicCommerceInd
     * @param string $payerAuthenticationExemptionCode
     * @param string $payerAuthenticationFailureToCompleteCode
     * @param string $paymentTrxChannelCode
     * @param string $programProtocolText
     * @param string[] $trxStatusText
     */
    public function __construct($authenticationMerchantName = null, $authenticationTokenValue = null, $authenticationValue = null, $cardNumberCollectionCode = null, $directoryServerTrxID = null, $electronicCommerceInd = null, $payerAuthenticationExemptionCode = null, $payerAuthenticationFailureToCompleteCode = null, $paymentTrxChannelCode = null, $programProtocolText = null, array $trxStatusText = array())
    {
        $this
            ->setAuthenticationMerchantName($authenticationMerchantName)
            ->setAuthenticationTokenValue($authenticationTokenValue)
            ->setAuthenticationValue($authenticationValue)
            ->setCardNumberCollectionCode($cardNumberCollectionCode)
            ->setDirectoryServerTrxID($directoryServerTrxID)
            ->setElectronicCommerceInd($electronicCommerceInd)
            ->setPayerAuthenticationExemptionCode($payerAuthenticationExemptionCode)
            ->setPayerAuthenticationFailureToCompleteCode($payerAuthenticationFailureToCompleteCode)
            ->setPaymentTrxChannelCode($paymentTrxChannelCode)
            ->setProgramProtocolText($programProtocolText)
            ->setTrxStatusText($trxStatusText);
    }
    /**
     * Get AuthenticationMerchantName value
     * @return string|null
     */
    public function getAuthenticationMerchantName()
    {
        return $this->AuthenticationMerchantName;
    }
    /**
     * Set AuthenticationMerchantName value
     * @param string $authenticationMerchantName
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setAuthenticationMerchantName($authenticationMerchantName = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationMerchantName) && !is_string($authenticationMerchantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationMerchantName, true), gettype($authenticationMerchantName)), __LINE__);
        }
        $this->AuthenticationMerchantName = $authenticationMerchantName;
        return $this;
    }
    /**
     * Get AuthenticationTokenValue value
     * @return string|null
     */
    public function getAuthenticationTokenValue()
    {
        return $this->AuthenticationTokenValue;
    }
    /**
     * Set AuthenticationTokenValue value
     * @param string $authenticationTokenValue
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setAuthenticationTokenValue($authenticationTokenValue = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationTokenValue) && !is_string($authenticationTokenValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationTokenValue, true), gettype($authenticationTokenValue)), __LINE__);
        }
        $this->AuthenticationTokenValue = $authenticationTokenValue;
        return $this;
    }
    /**
     * Get AuthenticationValue value
     * @return string|null
     */
    public function getAuthenticationValue()
    {
        return $this->AuthenticationValue;
    }
    /**
     * Set AuthenticationValue value
     * @param string $authenticationValue
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setAuthenticationValue($authenticationValue = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationValue) && !is_string($authenticationValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationValue, true), gettype($authenticationValue)), __LINE__);
        }
        $this->AuthenticationValue = $authenticationValue;
        return $this;
    }
    /**
     * Get CardNumberCollectionCode value
     * @return string|null
     */
    public function getCardNumberCollectionCode()
    {
        return $this->CardNumberCollectionCode;
    }
    /**
     * Set CardNumberCollectionCode value
     * @param string $cardNumberCollectionCode
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setCardNumberCollectionCode($cardNumberCollectionCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberCollectionCode) && !is_string($cardNumberCollectionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberCollectionCode, true), gettype($cardNumberCollectionCode)), __LINE__);
        }
        $this->CardNumberCollectionCode = $cardNumberCollectionCode;
        return $this;
    }
    /**
     * Get DirectoryServerTrxID value
     * @return string|null
     */
    public function getDirectoryServerTrxID()
    {
        return $this->DirectoryServerTrxID;
    }
    /**
     * Set DirectoryServerTrxID value
     * @param string $directoryServerTrxID
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setDirectoryServerTrxID($directoryServerTrxID = null)
    {
        // validation for constraint: string
        if (!is_null($directoryServerTrxID) && !is_string($directoryServerTrxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryServerTrxID, true), gettype($directoryServerTrxID)), __LINE__);
        }
        $this->DirectoryServerTrxID = $directoryServerTrxID;
        return $this;
    }
    /**
     * Get ElectronicCommerceInd value
     * @return string|null
     */
    public function getElectronicCommerceInd()
    {
        return $this->ElectronicCommerceInd;
    }
    /**
     * Set ElectronicCommerceInd value
     * @param string $electronicCommerceInd
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setElectronicCommerceInd($electronicCommerceInd = null)
    {
        // validation for constraint: string
        if (!is_null($electronicCommerceInd) && !is_string($electronicCommerceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($electronicCommerceInd, true), gettype($electronicCommerceInd)), __LINE__);
        }
        $this->ElectronicCommerceInd = $electronicCommerceInd;
        return $this;
    }
    /**
     * Get PayerAuthenticationExemptionCode value
     * @return string|null
     */
    public function getPayerAuthenticationExemptionCode()
    {
        return $this->PayerAuthenticationExemptionCode;
    }
    /**
     * Set PayerAuthenticationExemptionCode value
     * @param string $payerAuthenticationExemptionCode
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setPayerAuthenticationExemptionCode($payerAuthenticationExemptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($payerAuthenticationExemptionCode) && !is_string($payerAuthenticationExemptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAuthenticationExemptionCode, true), gettype($payerAuthenticationExemptionCode)), __LINE__);
        }
        $this->PayerAuthenticationExemptionCode = $payerAuthenticationExemptionCode;
        return $this;
    }
    /**
     * Get PayerAuthenticationFailureToCompleteCode value
     * @return string|null
     */
    public function getPayerAuthenticationFailureToCompleteCode()
    {
        return $this->PayerAuthenticationFailureToCompleteCode;
    }
    /**
     * Set PayerAuthenticationFailureToCompleteCode value
     * @param string $payerAuthenticationFailureToCompleteCode
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setPayerAuthenticationFailureToCompleteCode($payerAuthenticationFailureToCompleteCode = null)
    {
        // validation for constraint: string
        if (!is_null($payerAuthenticationFailureToCompleteCode) && !is_string($payerAuthenticationFailureToCompleteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAuthenticationFailureToCompleteCode, true), gettype($payerAuthenticationFailureToCompleteCode)), __LINE__);
        }
        $this->PayerAuthenticationFailureToCompleteCode = $payerAuthenticationFailureToCompleteCode;
        return $this;
    }
    /**
     * Get PaymentTrxChannelCode value
     * @return string|null
     */
    public function getPaymentTrxChannelCode()
    {
        return $this->PaymentTrxChannelCode;
    }
    /**
     * Set PaymentTrxChannelCode value
     * @param string $paymentTrxChannelCode
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setPaymentTrxChannelCode($paymentTrxChannelCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTrxChannelCode) && !is_string($paymentTrxChannelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTrxChannelCode, true), gettype($paymentTrxChannelCode)), __LINE__);
        }
        $this->PaymentTrxChannelCode = $paymentTrxChannelCode;
        return $this;
    }
    /**
     * Get ProgramProtocolText value
     * @return string|null
     */
    public function getProgramProtocolText()
    {
        return $this->ProgramProtocolText;
    }
    /**
     * Set ProgramProtocolText value
     * @param string $programProtocolText
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setProgramProtocolText($programProtocolText = null)
    {
        // validation for constraint: string
        if (!is_null($programProtocolText) && !is_string($programProtocolText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programProtocolText, true), gettype($programProtocolText)), __LINE__);
        }
        $this->ProgramProtocolText = $programProtocolText;
        return $this;
    }
    /**
     * Get TrxStatusText value
     * @return string[]|null
     */
    public function getTrxStatusText()
    {
        return $this->TrxStatusText;
    }
    /**
     * This method is responsible for validating the values passed to the setTrxStatusText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrxStatusText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrxStatusTextForArrayConstraintsFromSetTrxStatusText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $securePaymentVersion2TypeTrxStatusTextItem) {
            // validation for constraint: itemType
            if (!is_string($securePaymentVersion2TypeTrxStatusTextItem)) {
                $invalidValues[] = is_object($securePaymentVersion2TypeTrxStatusTextItem) ? get_class($securePaymentVersion2TypeTrxStatusTextItem) : sprintf('%s(%s)', gettype($securePaymentVersion2TypeTrxStatusTextItem), var_export($securePaymentVersion2TypeTrxStatusTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrxStatusText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrxStatusText value
     * @throws \InvalidArgumentException
     * @param string[] $trxStatusText
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function setTrxStatusText(array $trxStatusText = array())
    {
        // validation for constraint: array
        if ('' !== ($trxStatusTextArrayErrorMessage = self::validateTrxStatusTextForArrayConstraintsFromSetTrxStatusText($trxStatusText))) {
            throw new \InvalidArgumentException($trxStatusTextArrayErrorMessage, __LINE__);
        }
        $this->TrxStatusText = $trxStatusText;
        return $this;
    }
    /**
     * Add item to TrxStatusText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SecurePaymentVersion2Type
     */
    public function addToTrxStatusText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TrxStatusText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrxStatusText[] = $item;
        return $this;
    }
}
