<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurePaymentAuthenticationInstructionsVersion2Type
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Data returned from the Directory Server/ACS containing the PAReq and the ACS URL that enable the cardholder to authenticate. Applicable for 3D-Secure. Applicable for 3D Secure Version V 2.0.
 * @subpackage Structs
 */
class SecurePaymentAuthenticationInstructionsVersion2Type extends AbstractStructBase
{
    /**
     * The ChallengeMandateInd
     * Meta information extracted from the WSDL
     * - documentation: Airline specify whether or not Seller should challenge 3D-Secure authentication. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ChallengeMandateInd;
    /**
     * The AcquirerBankIdentificationNumber
     * Meta information extracted from the WSDL
     * - documentation: BIN of acquirer. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $AcquirerBankIdentificationNumber;
    /**
     * The MerchantAccount
     * Meta information extracted from the WSDL
     * - documentation: A person or company that sells goods or services. A merchant works with an Acquiring Bank to apply for and receive a Merchant Account (an account that allows the Merchant to accept Credit and debit cards). Whenever a customer
     * purchases an item with a Credit or debit card, the Merchant submits the purchase Transaction information to its Acquiring Bank, which will then submit it through the card association network to the card holder's Issuing Bank. The Issuing Bank will
     * approve or decline the charge, and bill the cardholder the amount due to the Merchant.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MerchantAccountType
     */
    public $MerchantAccount;
    /**
     * The RequestorURI
     * Meta information extracted from the WSDL
     * - documentation: Fully qualified URL of 3DS Requestor web site or customer care site. | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the
     * World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestorURI;
    /**
     * Constructor method for SecurePaymentAuthenticationInstructionsVersion2Type
     * @uses SecurePaymentAuthenticationInstructionsVersion2Type::setChallengeMandateInd()
     * @uses SecurePaymentAuthenticationInstructionsVersion2Type::setAcquirerBankIdentificationNumber()
     * @uses SecurePaymentAuthenticationInstructionsVersion2Type::setMerchantAccount()
     * @uses SecurePaymentAuthenticationInstructionsVersion2Type::setRequestorURI()
     * @param bool $challengeMandateInd
     * @param float $acquirerBankIdentificationNumber
     * @param \StructType\MerchantAccountType $merchantAccount
     * @param string $requestorURI
     */
    public function __construct($challengeMandateInd = null, $acquirerBankIdentificationNumber = null, \StructType\MerchantAccountType $merchantAccount = null, $requestorURI = null)
    {
        $this
            ->setChallengeMandateInd($challengeMandateInd)
            ->setAcquirerBankIdentificationNumber($acquirerBankIdentificationNumber)
            ->setMerchantAccount($merchantAccount)
            ->setRequestorURI($requestorURI);
    }
    /**
     * Get ChallengeMandateInd value
     * @return bool
     */
    public function getChallengeMandateInd()
    {
        return $this->ChallengeMandateInd;
    }
    /**
     * Set ChallengeMandateInd value
     * @param bool $challengeMandateInd
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion2Type
     */
    public function setChallengeMandateInd($challengeMandateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($challengeMandateInd) && !is_bool($challengeMandateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($challengeMandateInd, true), gettype($challengeMandateInd)), __LINE__);
        }
        $this->ChallengeMandateInd = $challengeMandateInd;
        return $this;
    }
    /**
     * Get AcquirerBankIdentificationNumber value
     * @return float|null
     */
    public function getAcquirerBankIdentificationNumber()
    {
        return $this->AcquirerBankIdentificationNumber;
    }
    /**
     * Set AcquirerBankIdentificationNumber value
     * @param float $acquirerBankIdentificationNumber
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion2Type
     */
    public function setAcquirerBankIdentificationNumber($acquirerBankIdentificationNumber = null)
    {
        // validation for constraint: float
        if (!is_null($acquirerBankIdentificationNumber) && !(is_float($acquirerBankIdentificationNumber) || is_numeric($acquirerBankIdentificationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($acquirerBankIdentificationNumber, true), gettype($acquirerBankIdentificationNumber)), __LINE__);
        }
        $this->AcquirerBankIdentificationNumber = $acquirerBankIdentificationNumber;
        return $this;
    }
    /**
     * Get MerchantAccount value
     * @return \StructType\MerchantAccountType|null
     */
    public function getMerchantAccount()
    {
        return $this->MerchantAccount;
    }
    /**
     * Set MerchantAccount value
     * @param \StructType\MerchantAccountType $merchantAccount
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion2Type
     */
    public function setMerchantAccount(\StructType\MerchantAccountType $merchantAccount = null)
    {
        $this->MerchantAccount = $merchantAccount;
        return $this;
    }
    /**
     * Get RequestorURI value
     * @return string|null
     */
    public function getRequestorURI()
    {
        return $this->RequestorURI;
    }
    /**
     * Set RequestorURI value
     * @param string $requestorURI
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion2Type
     */
    public function setRequestorURI($requestorURI = null)
    {
        // validation for constraint: string
        if (!is_null($requestorURI) && !is_string($requestorURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorURI, true), gettype($requestorURI)), __LINE__);
        }
        $this->RequestorURI = $requestorURI;
        return $this;
    }
}
