<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurePaymentAuthenticationInstructionsVersion1Type
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Data returned from the Directory Server/ACS containing the PAReq and the ACS URL that enable to cardholder to authenticate. Applicable for 3D Secure Version V 1.0.
 * @subpackage Structs
 */
class SecurePaymentAuthenticationInstructionsVersion1Type extends AbstractStructBase
{
    /**
     * The AuthenticationTrxID
     * Meta information extracted from the WSDL
     * - documentation: Unique 3D Secure transaction reference number assigned by Access Control System (ACS). Example: Qzl3WVc1TVpXNW5kR2crUEcxbGMzTmhaMlZK WkQ1UVFWSmxjUzB4TWpnNUSXcKTmprNU5EWThMMjFsYzNOaFoyVkpRDQ4TDAxRVBqd3ZVVEr Note: This is typically
     * required for ACS systems that support Status Query. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthenticationTrxID;
    /**
     * The MerchantData
     * Meta information extracted from the WSDL
     * - documentation: Containing merchant state data that must be returned to the merchant. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantData;
    /**
     * The PayerAuthenticationRequestText
     * Meta information extracted from the WSDL
     * - documentation: The authentication request for the 3-D Secure transaction. When sending the customer's browser to the card issuer's ACS, the system will need to include the PaReq in the HTTPS POST.'+CHAR(13)+''+CHAR(10)+'Example:
     * eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerAuthenticationRequestText;
    /**
     * The RedirectionURL
     * Meta information extracted from the WSDL
     * - documentation: 3DS Access Control System URL. Note: This is the URL of the Issuing Bank's ACS, to which the cardholder needs to be re-directed. The browser should simply redirect to this URL. ACS or Access Control Server | A string of characters
     * used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RedirectionURL;
    /**
     * The TerminationURL
     * Meta information extracted from the WSDL
     * - documentation: The URL to which the user will be directed to at the conclusion of 3D secure authentication. Example: http://ba.com/paymentResultSuccess | A string of characters used to identify a resource. Such identification enables interaction
     * with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TerminationURL;
    /**
     * Constructor method for SecurePaymentAuthenticationInstructionsVersion1Type
     * @uses SecurePaymentAuthenticationInstructionsVersion1Type::setAuthenticationTrxID()
     * @uses SecurePaymentAuthenticationInstructionsVersion1Type::setMerchantData()
     * @uses SecurePaymentAuthenticationInstructionsVersion1Type::setPayerAuthenticationRequestText()
     * @uses SecurePaymentAuthenticationInstructionsVersion1Type::setRedirectionURL()
     * @uses SecurePaymentAuthenticationInstructionsVersion1Type::setTerminationURL()
     * @param string $authenticationTrxID
     * @param string $merchantData
     * @param string $payerAuthenticationRequestText
     * @param string $redirectionURL
     * @param string $terminationURL
     */
    public function __construct($authenticationTrxID = null, $merchantData = null, $payerAuthenticationRequestText = null, $redirectionURL = null, $terminationURL = null)
    {
        $this
            ->setAuthenticationTrxID($authenticationTrxID)
            ->setMerchantData($merchantData)
            ->setPayerAuthenticationRequestText($payerAuthenticationRequestText)
            ->setRedirectionURL($redirectionURL)
            ->setTerminationURL($terminationURL);
    }
    /**
     * Get AuthenticationTrxID value
     * @return string|null
     */
    public function getAuthenticationTrxID()
    {
        return $this->AuthenticationTrxID;
    }
    /**
     * Set AuthenticationTrxID value
     * @param string $authenticationTrxID
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion1Type
     */
    public function setAuthenticationTrxID($authenticationTrxID = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationTrxID) && !is_string($authenticationTrxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationTrxID, true), gettype($authenticationTrxID)), __LINE__);
        }
        $this->AuthenticationTrxID = $authenticationTrxID;
        return $this;
    }
    /**
     * Get MerchantData value
     * @return string|null
     */
    public function getMerchantData()
    {
        return $this->MerchantData;
    }
    /**
     * Set MerchantData value
     * @param string $merchantData
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion1Type
     */
    public function setMerchantData($merchantData = null)
    {
        // validation for constraint: string
        if (!is_null($merchantData) && !is_string($merchantData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantData, true), gettype($merchantData)), __LINE__);
        }
        $this->MerchantData = $merchantData;
        return $this;
    }
    /**
     * Get PayerAuthenticationRequestText value
     * @return string|null
     */
    public function getPayerAuthenticationRequestText()
    {
        return $this->PayerAuthenticationRequestText;
    }
    /**
     * Set PayerAuthenticationRequestText value
     * @param string $payerAuthenticationRequestText
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion1Type
     */
    public function setPayerAuthenticationRequestText($payerAuthenticationRequestText = null)
    {
        // validation for constraint: string
        if (!is_null($payerAuthenticationRequestText) && !is_string($payerAuthenticationRequestText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAuthenticationRequestText, true), gettype($payerAuthenticationRequestText)), __LINE__);
        }
        $this->PayerAuthenticationRequestText = $payerAuthenticationRequestText;
        return $this;
    }
    /**
     * Get RedirectionURL value
     * @return string|null
     */
    public function getRedirectionURL()
    {
        return $this->RedirectionURL;
    }
    /**
     * Set RedirectionURL value
     * @param string $redirectionURL
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion1Type
     */
    public function setRedirectionURL($redirectionURL = null)
    {
        // validation for constraint: string
        if (!is_null($redirectionURL) && !is_string($redirectionURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectionURL, true), gettype($redirectionURL)), __LINE__);
        }
        $this->RedirectionURL = $redirectionURL;
        return $this;
    }
    /**
     * Get TerminationURL value
     * @return string|null
     */
    public function getTerminationURL()
    {
        return $this->TerminationURL;
    }
    /**
     * Set TerminationURL value
     * @param string $terminationURL
     * @return \StructType\SecurePaymentAuthenticationInstructionsVersion1Type
     */
    public function setTerminationURL($terminationURL = null)
    {
        // validation for constraint: string
        if (!is_null($terminationURL) && !is_string($terminationURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminationURL, true), gettype($terminationURL)), __LINE__);
        }
        $this->TerminationURL = $terminationURL;
        return $this;
    }
}
