<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline defined group of seats sharing common characteristics.
 * @subpackage Structs
 */
class SeatProfileType extends AbstractStructBase
{
    /**
     * The SeatProfileID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier associated to this Seat Profile. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SeatProfileID;
    /**
     * The MarketingInfo
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescType[]
     */
    public $MarketingInfo;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The SeatCharacteristicCode
     * Meta information extracted from the WSDL
     * - documentation: Characteristic of an aircraft seat e.g. A (Aisle seat), E (Exit and emergency exit),..., according to PADIS code list 9825. | Refers to aircraft seat characteristic codes e.g. A (Aisle seat), E (Exit and emergency exit). See PADIS
     * code list 9825. {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Seat characteristic,coded{/codeListName} {codeListIdentifier}9825{/codeListIdentifier} | Specifies a Seat Characteristic code.
     * - base: SeatCharacteristicCodeContentType
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SeatCharacteristicCode;
    /**
     * The SeatKeywords
     * Meta information extracted from the WSDL
     * - documentation: Contextual information to further describe something using a key-value pair.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValuePropertyType[]
     */
    public $SeatKeywords;
    /**
     * The SeatPitchMeasure
     * Meta information extracted from the WSDL
     * - documentation: Measure of a given seat's pitch.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $SeatPitchMeasure;
    /**
     * The SeatWidthMeasure
     * Meta information extracted from the WSDL
     * - documentation: Measure of a given seat's width.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $SeatWidthMeasure;
    /**
     * Constructor method for SeatProfileType
     * @uses SeatProfileType::setSeatProfileID()
     * @uses SeatProfileType::setMarketingInfo()
     * @uses SeatProfileType::setRichMedia()
     * @uses SeatProfileType::setSeatCharacteristicCode()
     * @uses SeatProfileType::setSeatKeywords()
     * @uses SeatProfileType::setSeatPitchMeasure()
     * @uses SeatProfileType::setSeatWidthMeasure()
     * @param string $seatProfileID
     * @param \StructType\DescType[] $marketingInfo
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param string[] $seatCharacteristicCode
     * @param \StructType\KeyValuePropertyType[] $seatKeywords
     * @param \StructType\MeasureType $seatPitchMeasure
     * @param \StructType\MeasureType $seatWidthMeasure
     */
    public function __construct($seatProfileID = null, array $marketingInfo = array(), array $richMedia = array(), array $seatCharacteristicCode = array(), array $seatKeywords = array(), \StructType\MeasureType $seatPitchMeasure = null, \StructType\MeasureType $seatWidthMeasure = null)
    {
        $this
            ->setSeatProfileID($seatProfileID)
            ->setMarketingInfo($marketingInfo)
            ->setRichMedia($richMedia)
            ->setSeatCharacteristicCode($seatCharacteristicCode)
            ->setSeatKeywords($seatKeywords)
            ->setSeatPitchMeasure($seatPitchMeasure)
            ->setSeatWidthMeasure($seatWidthMeasure);
    }
    /**
     * Get SeatProfileID value
     * @return string
     */
    public function getSeatProfileID()
    {
        return $this->SeatProfileID;
    }
    /**
     * Set SeatProfileID value
     * @param string $seatProfileID
     * @return \StructType\SeatProfileType
     */
    public function setSeatProfileID($seatProfileID = null)
    {
        // validation for constraint: string
        if (!is_null($seatProfileID) && !is_string($seatProfileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatProfileID, true), gettype($seatProfileID)), __LINE__);
        }
        $this->SeatProfileID = $seatProfileID;
        return $this;
    }
    /**
     * Get MarketingInfo value
     * @return \StructType\DescType[]|null
     */
    public function getMarketingInfo()
    {
        return $this->MarketingInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingInfoForArrayConstraintsFromSetMarketingInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatProfileTypeMarketingInfoItem) {
            // validation for constraint: itemType
            if (!$seatProfileTypeMarketingInfoItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($seatProfileTypeMarketingInfoItem) ? get_class($seatProfileTypeMarketingInfoItem) : sprintf('%s(%s)', gettype($seatProfileTypeMarketingInfoItem), var_export($seatProfileTypeMarketingInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketingInfo property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketingInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $marketingInfo
     * @return \StructType\SeatProfileType
     */
    public function setMarketingInfo(array $marketingInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingInfoArrayErrorMessage = self::validateMarketingInfoForArrayConstraintsFromSetMarketingInfo($marketingInfo))) {
            throw new \InvalidArgumentException($marketingInfoArrayErrorMessage, __LINE__);
        }
        $this->MarketingInfo = $marketingInfo;
        return $this;
    }
    /**
     * Add item to MarketingInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\SeatProfileType
     */
    public function addToMarketingInfo(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The MarketingInfo property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketingInfo[] = $item;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatProfileTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$seatProfileTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($seatProfileTypeRichMediaItem) ? get_class($seatProfileTypeRichMediaItem) : sprintf('%s(%s)', gettype($seatProfileTypeRichMediaItem), var_export($seatProfileTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\SeatProfileType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\SeatProfileType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get SeatCharacteristicCode value
     * @return string[]|null
     */
    public function getSeatCharacteristicCode()
    {
        return $this->SeatCharacteristicCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatCharacteristicCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatCharacteristicCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatProfileTypeSeatCharacteristicCodeItem) {
            // validation for constraint: itemType
            if (!is_string($seatProfileTypeSeatCharacteristicCodeItem)) {
                $invalidValues[] = is_object($seatProfileTypeSeatCharacteristicCodeItem) ? get_class($seatProfileTypeSeatCharacteristicCodeItem) : sprintf('%s(%s)', gettype($seatProfileTypeSeatCharacteristicCodeItem), var_export($seatProfileTypeSeatCharacteristicCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string[] $seatCharacteristicCode
     * @return \StructType\SeatProfileType
     */
    public function setSeatCharacteristicCode(array $seatCharacteristicCode = array())
    {
        // validation for constraint: array
        if ('' !== ($seatCharacteristicCodeArrayErrorMessage = self::validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode($seatCharacteristicCode))) {
            throw new \InvalidArgumentException($seatCharacteristicCodeArrayErrorMessage, __LINE__);
        }
        $this->SeatCharacteristicCode = $seatCharacteristicCode;
        return $this;
    }
    /**
     * Add item to SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatProfileType
     */
    public function addToSeatCharacteristicCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatCharacteristicCode[] = $item;
        return $this;
    }
    /**
     * Get SeatKeywords value
     * @return \StructType\KeyValuePropertyType[]|null
     */
    public function getSeatKeywords()
    {
        return $this->SeatKeywords;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatKeywords method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatKeywords method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatKeywordsForArrayConstraintsFromSetSeatKeywords(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatProfileTypeSeatKeywordsItem) {
            // validation for constraint: itemType
            if (!$seatProfileTypeSeatKeywordsItem instanceof \StructType\KeyValuePropertyType) {
                $invalidValues[] = is_object($seatProfileTypeSeatKeywordsItem) ? get_class($seatProfileTypeSeatKeywordsItem) : sprintf('%s(%s)', gettype($seatProfileTypeSeatKeywordsItem), var_export($seatProfileTypeSeatKeywordsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatKeywords property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatKeywords value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType[] $seatKeywords
     * @return \StructType\SeatProfileType
     */
    public function setSeatKeywords(array $seatKeywords = array())
    {
        // validation for constraint: array
        if ('' !== ($seatKeywordsArrayErrorMessage = self::validateSeatKeywordsForArrayConstraintsFromSetSeatKeywords($seatKeywords))) {
            throw new \InvalidArgumentException($seatKeywordsArrayErrorMessage, __LINE__);
        }
        $this->SeatKeywords = $seatKeywords;
        return $this;
    }
    /**
     * Add item to SeatKeywords value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType $item
     * @return \StructType\SeatProfileType
     */
    public function addToSeatKeywords(\StructType\KeyValuePropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePropertyType) {
            throw new \InvalidArgumentException(sprintf('The SeatKeywords property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatKeywords[] = $item;
        return $this;
    }
    /**
     * Get SeatPitchMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getSeatPitchMeasure()
    {
        return $this->SeatPitchMeasure;
    }
    /**
     * Set SeatPitchMeasure value
     * @param \StructType\MeasureType $seatPitchMeasure
     * @return \StructType\SeatProfileType
     */
    public function setSeatPitchMeasure(\StructType\MeasureType $seatPitchMeasure = null)
    {
        $this->SeatPitchMeasure = $seatPitchMeasure;
        return $this;
    }
    /**
     * Get SeatWidthMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getSeatWidthMeasure()
    {
        return $this->SeatWidthMeasure;
    }
    /**
     * Set SeatWidthMeasure value
     * @param \StructType\MeasureType $seatWidthMeasure
     * @return \StructType\SeatProfileType
     */
    public function setSeatWidthMeasure(\StructType\MeasureType $seatWidthMeasure = null)
    {
        $this->SeatWidthMeasure = $seatWidthMeasure;
        return $this;
    }
}
