<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatProfileListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Seat Profile data list definition.
 * @subpackage Structs
 */
class SeatProfileListType extends AbstractStructBase
{
    /**
     * The SeatProfile
     * Meta information extracted from the WSDL
     * - documentation: Airline defined group of seats sharing common characteristics.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SeatProfileType[]
     */
    public $SeatProfile;
    /**
     * Constructor method for SeatProfileListType
     * @uses SeatProfileListType::setSeatProfile()
     * @param \StructType\SeatProfileType[] $seatProfile
     */
    public function __construct(array $seatProfile = array())
    {
        $this
            ->setSeatProfile($seatProfile);
    }
    /**
     * Get SeatProfile value
     * @return \StructType\SeatProfileType[]
     */
    public function getSeatProfile()
    {
        return $this->SeatProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatProfileForArrayConstraintsFromSetSeatProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatProfileListTypeSeatProfileItem) {
            // validation for constraint: itemType
            if (!$seatProfileListTypeSeatProfileItem instanceof \StructType\SeatProfileType) {
                $invalidValues[] = is_object($seatProfileListTypeSeatProfileItem) ? get_class($seatProfileListTypeSeatProfileItem) : sprintf('%s(%s)', gettype($seatProfileListTypeSeatProfileItem), var_export($seatProfileListTypeSeatProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatProfile property can only contain items of type \StructType\SeatProfileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatProfileType[] $seatProfile
     * @return \StructType\SeatProfileListType
     */
    public function setSeatProfile(array $seatProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($seatProfileArrayErrorMessage = self::validateSeatProfileForArrayConstraintsFromSetSeatProfile($seatProfile))) {
            throw new \InvalidArgumentException($seatProfileArrayErrorMessage, __LINE__);
        }
        $this->SeatProfile = $seatProfile;
        return $this;
    }
    /**
     * Add item to SeatProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatProfileType $item
     * @return \StructType\SeatProfileListType
     */
    public function addToSeatProfile(\StructType\SeatProfileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatProfileType) {
            throw new \InvalidArgumentException(sprintf('The SeatProfile property can only contain items of type \StructType\SeatProfileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatProfile[] = $item;
        return $this;
    }
}
