<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Seat service information used for long sells.
 * @subpackage Structs
 */
class SeatItemType extends AbstractStructBase
{
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Dated Operating Leg within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger Segment within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxSegmentRefID;
    /**
     * The ColumnID
     * Meta information extracted from the WSDL
     * - documentation: Alphabetic character identifying a seat within a row. | Specifies a column (e.g. A, B, C, etc.).
     * - base: xs:token
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]
     * @var string
     */
    public $ColumnID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Ordinal number identifying a seat row in an aircraft. | A mathematical number used for counting (positive whole number or integer).
     * - base: xs:integer
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $RowNumber;
    /**
     * The SeatProfileRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Seat Profile definition within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SeatProfileRefID;
    /**
     * Constructor method for SeatItemType
     * @uses SeatItemType::setDatedOperatingLegRefID()
     * @uses SeatItemType::setPaxRefID()
     * @uses SeatItemType::setPaxSegmentRefID()
     * @uses SeatItemType::setColumnID()
     * @uses SeatItemType::setPrice()
     * @uses SeatItemType::setRowNumber()
     * @uses SeatItemType::setSeatProfileRefID()
     * @param string[] $datedOperatingLegRefID
     * @param string $paxRefID
     * @param string $paxSegmentRefID
     * @param string $columnID
     * @param \StructType\PriceType $price
     * @param int $rowNumber
     * @param string[] $seatProfileRefID
     */
    public function __construct(array $datedOperatingLegRefID = array(), $paxRefID = null, $paxSegmentRefID = null, $columnID = null, \StructType\PriceType $price = null, $rowNumber = null, array $seatProfileRefID = array())
    {
        $this
            ->setDatedOperatingLegRefID($datedOperatingLegRefID)
            ->setPaxRefID($paxRefID)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setColumnID($columnID)
            ->setPrice($price)
            ->setRowNumber($rowNumber)
            ->setSeatProfileRefID($seatProfileRefID);
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatItemTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatItemTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($seatItemTypeDatedOperatingLegRefIDItem) ? get_class($seatItemTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($seatItemTypeDatedOperatingLegRefIDItem), var_export($seatItemTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\SeatItemType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatItemType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\SeatItemType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * Set PaxSegmentRefID value
     * @param string $paxSegmentRefID
     * @return \StructType\SeatItemType
     */
    public function setPaxSegmentRefID($paxSegmentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentRefID) && !is_string($paxSegmentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentRefID, true), gettype($paxSegmentRefID)), __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Get ColumnID value
     * @return string|null
     */
    public function getColumnID()
    {
        return $this->ColumnID;
    }
    /**
     * Set ColumnID value
     * @param string $columnID
     * @return \StructType\SeatItemType
     */
    public function setColumnID($columnID = null)
    {
        // validation for constraint: string
        if (!is_null($columnID) && !is_string($columnID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($columnID, true), gettype($columnID)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($columnID) && mb_strlen($columnID) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($columnID)), __LINE__);
        }
        // validation for constraint: pattern([A-Z])
        if (!is_null($columnID) && !preg_match('/[A-Z]/', $columnID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]', var_export($columnID, true)), __LINE__);
        }
        $this->ColumnID = $columnID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\SeatItemType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatItemType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rowNumber) && $rowNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rowNumber, true)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get SeatProfileRefID value
     * @return string[]|null
     */
    public function getSeatProfileRefID()
    {
        return $this->SeatProfileRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatProfileRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatProfileRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatProfileRefIDForArrayConstraintsFromSetSeatProfileRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatItemTypeSeatProfileRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatItemTypeSeatProfileRefIDItem)) {
                $invalidValues[] = is_object($seatItemTypeSeatProfileRefIDItem) ? get_class($seatItemTypeSeatProfileRefIDItem) : sprintf('%s(%s)', gettype($seatItemTypeSeatProfileRefIDItem), var_export($seatItemTypeSeatProfileRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatProfileRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatProfileRefID value
     * @throws \InvalidArgumentException
     * @param string[] $seatProfileRefID
     * @return \StructType\SeatItemType
     */
    public function setSeatProfileRefID(array $seatProfileRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($seatProfileRefIDArrayErrorMessage = self::validateSeatProfileRefIDForArrayConstraintsFromSetSeatProfileRefID($seatProfileRefID))) {
            throw new \InvalidArgumentException($seatProfileRefIDArrayErrorMessage, __LINE__);
        }
        $this->SeatProfileRefID = $seatProfileRefID;
        return $this;
    }
    /**
     * Add item to SeatProfileRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatItemType
     */
    public function addToSeatProfileRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatProfileRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatProfileRefID[] = $item;
        return $this;
    }
}
