<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAvailRequestOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: A seat availability request individually priced item within a Service Request Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * @subpackage Structs
 */
class SeatAvailRequestOrderItemType extends AbstractStructBase
{
    /**
     * The OrderItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemID;
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Leg ID from a previously returned Offer. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID from a previously returned Offer. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger Segment ID from a previously returned Offer. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxSegmentRefID;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Service Key specialization of an instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can
     * be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceKeyType[]
     */
    public $Service;
    /**
     * The SpecialService
     * Meta information extracted from the WSDL
     * - documentation: Special service information
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SpecialServiceType
     */
    public $SpecialService;
    /**
     * Constructor method for SeatAvailRequestOrderItemType
     * @uses SeatAvailRequestOrderItemType::setOrderItemID()
     * @uses SeatAvailRequestOrderItemType::setDatedOperatingLegRefID()
     * @uses SeatAvailRequestOrderItemType::setOwnerCode()
     * @uses SeatAvailRequestOrderItemType::setPaxRefID()
     * @uses SeatAvailRequestOrderItemType::setPaxSegmentRefID()
     * @uses SeatAvailRequestOrderItemType::setService()
     * @uses SeatAvailRequestOrderItemType::setSpecialService()
     * @param string $orderItemID
     * @param string[] $datedOperatingLegRefID
     * @param string $ownerCode
     * @param string[] $paxRefID
     * @param string[] $paxSegmentRefID
     * @param \StructType\ServiceKeyType[] $service
     * @param \StructType\SpecialServiceType $specialService
     */
    public function __construct($orderItemID = null, array $datedOperatingLegRefID = array(), $ownerCode = null, array $paxRefID = array(), array $paxSegmentRefID = array(), array $service = array(), \StructType\SpecialServiceType $specialService = null)
    {
        $this
            ->setOrderItemID($orderItemID)
            ->setDatedOperatingLegRefID($datedOperatingLegRefID)
            ->setOwnerCode($ownerCode)
            ->setPaxRefID($paxRefID)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setService($service)
            ->setSpecialService($specialService);
    }
    /**
     * Get OrderItemID value
     * @return string
     */
    public function getOrderItemID()
    {
        return $this->OrderItemID;
    }
    /**
     * Set OrderItemID value
     * @param string $orderItemID
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function setOrderItemID($orderItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemID) && !is_string($orderItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemID, true), gettype($orderItemID)), __LINE__);
        }
        $this->OrderItemID = $orderItemID;
        return $this;
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]|null
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestOrderItemTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatAvailRequestOrderItemTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($seatAvailRequestOrderItemTypeDatedOperatingLegRefIDItem) ? get_class($seatAvailRequestOrderItemTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($seatAvailRequestOrderItemTypeDatedOperatingLegRefIDItem), var_export($seatAvailRequestOrderItemTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestOrderItemTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatAvailRequestOrderItemTypePaxRefIDItem)) {
                $invalidValues[] = is_object($seatAvailRequestOrderItemTypePaxRefIDItem) ? get_class($seatAvailRequestOrderItemTypePaxRefIDItem) : sprintf('%s(%s)', gettype($seatAvailRequestOrderItemTypePaxRefIDItem), var_export($seatAvailRequestOrderItemTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string[]|null
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestOrderItemTypePaxSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatAvailRequestOrderItemTypePaxSegmentRefIDItem)) {
                $invalidValues[] = is_object($seatAvailRequestOrderItemTypePaxSegmentRefIDItem) ? get_class($seatAvailRequestOrderItemTypePaxSegmentRefIDItem) : sprintf('%s(%s)', gettype($seatAvailRequestOrderItemTypePaxSegmentRefIDItem), var_export($seatAvailRequestOrderItemTypePaxSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxSegmentRefID
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function setPaxSegmentRefID(array $paxSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentRefIDArrayErrorMessage = self::validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID($paxSegmentRefID))) {
            throw new \InvalidArgumentException($paxSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Add item to PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function addToPaxSegmentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegmentRefID[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ServiceKeyType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestOrderItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$seatAvailRequestOrderItemTypeServiceItem instanceof \StructType\ServiceKeyType) {
                $invalidValues[] = is_object($seatAvailRequestOrderItemTypeServiceItem) ? get_class($seatAvailRequestOrderItemTypeServiceItem) : sprintf('%s(%s)', gettype($seatAvailRequestOrderItemTypeServiceItem), var_export($seatAvailRequestOrderItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\ServiceKeyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceKeyType[] $service
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceKeyType $item
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function addToService(\StructType\ServiceKeyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceKeyType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\ServiceKeyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get SpecialService value
     * @return \StructType\SpecialServiceType|null
     */
    public function getSpecialService()
    {
        return $this->SpecialService;
    }
    /**
     * Set SpecialService value
     * @param \StructType\SpecialServiceType $specialService
     * @return \StructType\SeatAvailRequestOrderItemType
     */
    public function setSpecialService(\StructType\SpecialServiceType $specialService = null)
    {
        $this->SpecialService = $specialService;
        return $this;
    }
}
