<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAvailOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a specialized seat availability offer item used in the context of a Shopping Request. Generic offer item definition is: A priced grouping of one or more services within an Offer. The Offer Item assigns a total price for all
 * included services for all passengers and all segments referenced. Once constructed, the OfferItem cannot be modified.
 * @subpackage Structs
 */
class SeatAvailOfferItemType extends AbstractStructBase
{
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Offer. Exceeding 64 characters or use of dashes is not recommended. | An identifier is a character string used to uniquely identify one instance of an object within an
     * identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemID;
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Leg ID from a previously returned Offer. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Deprecation 21.1 Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes.
     * {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID from a previously returned Offer. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger Segment ID from a previously returned Offer. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxSegmentRefID;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Service Id key specialization of an instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service
     * can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceIdKeyType[]
     */
    public $Service;
    /**
     * Constructor method for SeatAvailOfferItemType
     * @uses SeatAvailOfferItemType::setOfferItemID()
     * @uses SeatAvailOfferItemType::setDatedOperatingLegRefID()
     * @uses SeatAvailOfferItemType::setOwnerCode()
     * @uses SeatAvailOfferItemType::setPaxRefID()
     * @uses SeatAvailOfferItemType::setPaxSegmentRefID()
     * @uses SeatAvailOfferItemType::setService()
     * @param string $offerItemID
     * @param string[] $datedOperatingLegRefID
     * @param string $ownerCode
     * @param string[] $paxRefID
     * @param string[] $paxSegmentRefID
     * @param \StructType\ServiceIdKeyType[] $service
     */
    public function __construct($offerItemID = null, array $datedOperatingLegRefID = array(), $ownerCode = null, array $paxRefID = array(), array $paxSegmentRefID = array(), array $service = array())
    {
        $this
            ->setOfferItemID($offerItemID)
            ->setDatedOperatingLegRefID($datedOperatingLegRefID)
            ->setOwnerCode($ownerCode)
            ->setPaxRefID($paxRefID)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setService($service);
    }
    /**
     * Get OfferItemID value
     * @return string
     */
    public function getOfferItemID()
    {
        return $this->OfferItemID;
    }
    /**
     * Set OfferItemID value
     * @param string $offerItemID
     * @return \StructType\SeatAvailOfferItemType
     */
    public function setOfferItemID($offerItemID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemID) && !is_string($offerItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemID, true), gettype($offerItemID)), __LINE__);
        }
        $this->OfferItemID = $offerItemID;
        return $this;
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]|null
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailOfferItemTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatAvailOfferItemTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($seatAvailOfferItemTypeDatedOperatingLegRefIDItem) ? get_class($seatAvailOfferItemTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($seatAvailOfferItemTypeDatedOperatingLegRefIDItem), var_export($seatAvailOfferItemTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\SeatAvailOfferItemType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatAvailOfferItemType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\SeatAvailOfferItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailOfferItemTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatAvailOfferItemTypePaxRefIDItem)) {
                $invalidValues[] = is_object($seatAvailOfferItemTypePaxRefIDItem) ? get_class($seatAvailOfferItemTypePaxRefIDItem) : sprintf('%s(%s)', gettype($seatAvailOfferItemTypePaxRefIDItem), var_export($seatAvailOfferItemTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\SeatAvailOfferItemType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatAvailOfferItemType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string[]|null
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailOfferItemTypePaxSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatAvailOfferItemTypePaxSegmentRefIDItem)) {
                $invalidValues[] = is_object($seatAvailOfferItemTypePaxSegmentRefIDItem) ? get_class($seatAvailOfferItemTypePaxSegmentRefIDItem) : sprintf('%s(%s)', gettype($seatAvailOfferItemTypePaxSegmentRefIDItem), var_export($seatAvailOfferItemTypePaxSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxSegmentRefID
     * @return \StructType\SeatAvailOfferItemType
     */
    public function setPaxSegmentRefID(array $paxSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentRefIDArrayErrorMessage = self::validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID($paxSegmentRefID))) {
            throw new \InvalidArgumentException($paxSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Add item to PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatAvailOfferItemType
     */
    public function addToPaxSegmentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegmentRefID[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ServiceIdKeyType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailOfferItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$seatAvailOfferItemTypeServiceItem instanceof \StructType\ServiceIdKeyType) {
                $invalidValues[] = is_object($seatAvailOfferItemTypeServiceItem) ? get_class($seatAvailOfferItemTypeServiceItem) : sprintf('%s(%s)', gettype($seatAvailOfferItemTypeServiceItem), var_export($seatAvailOfferItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\ServiceIdKeyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceIdKeyType[] $service
     * @return \StructType\SeatAvailOfferItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceIdKeyType $item
     * @return \StructType\SeatAvailOfferItemType
     */
    public function addToService(\StructType\ServiceIdKeyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceIdKeyType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\ServiceIdKeyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
}
