<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesBranchType StructType
 * Meta information extracted from the WSDL
 * - documentation: An organizational unit with responsibility over sales in a market, for a product or service and under any other specified criteria.
 * @subpackage Structs
 */
class SalesBranchType extends AbstractStructBase
{
    /**
     * The SalesBranchID
     * Meta information extracted from the WSDL
     * - documentation: The industry wide unique identifier of the sales branch. Commonly, a value from the Pseudo City Code may be used, or a bi-latterly agreed code. When the latter it must only be used between parties that hold an appropriate
     * translation. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesBranchID;
    /**
     * Constructor method for SalesBranchType
     * @uses SalesBranchType::setSalesBranchID()
     * @param string $salesBranchID
     */
    public function __construct($salesBranchID = null)
    {
        $this
            ->setSalesBranchID($salesBranchID);
    }
    /**
     * Get SalesBranchID value
     * @return string
     */
    public function getSalesBranchID()
    {
        return $this->SalesBranchID;
    }
    /**
     * Set SalesBranchID value
     * @param string $salesBranchID
     * @return \StructType\SalesBranchType
     */
    public function setSalesBranchID($salesBranchID = null)
    {
        // validation for constraint: string
        if (!is_null($salesBranchID) && !is_string($salesBranchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesBranchID, true), gettype($salesBranchID)), __LINE__);
        }
        $this->SalesBranchID = $salesBranchID;
        return $this;
    }
}
