<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReshopResultsType StructType
 * Meta information extracted from the WSDL
 * - documentation: ReshopResults
 * @subpackage Structs
 */
class ReshopResultsType extends AbstractStructBase
{
    /**
     * The NoChangeInd
     * Meta information extracted from the WSDL
     * - documentation: This indicates that there have been no changes to an order.
     * - choice: NoChangeInd | RepricedOffer | ReshopOffers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NoChangeIndType
     */
    public $NoChangeInd;
    /**
     * The RepricedOffer
     * Meta information extracted from the WSDL
     * - documentation: Function used to request the repricing of an existing Order, possibly as a consequence of expired TimeLimits. Airline returns Offers/OfferItems that describe the changes incurred from the reprice request.
     * - choice: NoChangeInd | RepricedOffer | ReshopOffers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RepricedOfferType
     */
    public $RepricedOffer;
    /**
     * The ReshopOffers
     * Meta information extracted from the WSDL
     * - documentation: Reshopped Carrier Offers.
     * - choice: NoChangeInd | RepricedOffer | ReshopOffers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReshopOffersType
     */
    public $ReshopOffers;
    /**
     * Constructor method for ReshopResultsType
     * @uses ReshopResultsType::setNoChangeInd()
     * @uses ReshopResultsType::setRepricedOffer()
     * @uses ReshopResultsType::setReshopOffers()
     * @param \StructType\NoChangeIndType $noChangeInd
     * @param \StructType\RepricedOfferType $repricedOffer
     * @param \StructType\ReshopOffersType $reshopOffers
     */
    public function __construct(\StructType\NoChangeIndType $noChangeInd = null, \StructType\RepricedOfferType $repricedOffer = null, \StructType\ReshopOffersType $reshopOffers = null)
    {
        $this
            ->setNoChangeInd($noChangeInd)
            ->setRepricedOffer($repricedOffer)
            ->setReshopOffers($reshopOffers);
    }
    /**
     * Get NoChangeInd value
     * @return \StructType\NoChangeIndType
     */
    public function getNoChangeInd()
    {
        return isset($this->NoChangeInd) ? $this->NoChangeInd : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNoChangeInd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNoChangeInd method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNoChangeIndForChoiceConstraintsFromSetNoChangeInd($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'RepricedOffer',
            'ReshopOffers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NoChangeInd can\'t be set as the property %s is already set. Only one property must be set among these properties: NoChangeInd, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NoChangeInd value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NoChangeIndType $noChangeInd
     * @return \StructType\ReshopResultsType
     */
    public function setNoChangeInd(\StructType\NoChangeIndType $noChangeInd = null)
    {
        // validation for constraint: choice(NoChangeInd, RepricedOffer, ReshopOffers)
        if ('' !== ($noChangeIndChoiceErrorMessage = self::validateNoChangeIndForChoiceConstraintsFromSetNoChangeInd($noChangeInd))) {
            throw new \InvalidArgumentException($noChangeIndChoiceErrorMessage, __LINE__);
        }
        if (is_null($noChangeInd) || (is_array($noChangeInd) && empty($noChangeInd))) {
            unset($this->NoChangeInd);
        } else {
            $this->NoChangeInd = $noChangeInd;
        }
        return $this;
    }
    /**
     * Get RepricedOffer value
     * @return \StructType\RepricedOfferType
     */
    public function getRepricedOffer()
    {
        return isset($this->RepricedOffer) ? $this->RepricedOffer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRepricedOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRepricedOffer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRepricedOfferForChoiceConstraintsFromSetRepricedOffer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NoChangeInd',
            'ReshopOffers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RepricedOffer can\'t be set as the property %s is already set. Only one property must be set among these properties: RepricedOffer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RepricedOffer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RepricedOfferType $repricedOffer
     * @return \StructType\ReshopResultsType
     */
    public function setRepricedOffer(\StructType\RepricedOfferType $repricedOffer = null)
    {
        // validation for constraint: choice(NoChangeInd, RepricedOffer, ReshopOffers)
        if ('' !== ($repricedOfferChoiceErrorMessage = self::validateRepricedOfferForChoiceConstraintsFromSetRepricedOffer($repricedOffer))) {
            throw new \InvalidArgumentException($repricedOfferChoiceErrorMessage, __LINE__);
        }
        if (is_null($repricedOffer) || (is_array($repricedOffer) && empty($repricedOffer))) {
            unset($this->RepricedOffer);
        } else {
            $this->RepricedOffer = $repricedOffer;
        }
        return $this;
    }
    /**
     * Get ReshopOffers value
     * @return \StructType\ReshopOffersType
     */
    public function getReshopOffers()
    {
        return isset($this->ReshopOffers) ? $this->ReshopOffers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReshopOffers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReshopOffers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReshopOffersForChoiceConstraintsFromSetReshopOffers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NoChangeInd',
            'RepricedOffer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ReshopOffers can\'t be set as the property %s is already set. Only one property must be set among these properties: ReshopOffers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ReshopOffers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReshopOffersType $reshopOffers
     * @return \StructType\ReshopResultsType
     */
    public function setReshopOffers(\StructType\ReshopOffersType $reshopOffers = null)
    {
        // validation for constraint: choice(NoChangeInd, RepricedOffer, ReshopOffers)
        if ('' !== ($reshopOffersChoiceErrorMessage = self::validateReshopOffersForChoiceConstraintsFromSetReshopOffers($reshopOffers))) {
            throw new \InvalidArgumentException($reshopOffersChoiceErrorMessage, __LINE__);
        }
        if (is_null($reshopOffers) || (is_array($reshopOffers) && empty($reshopOffers))) {
            unset($this->ReshopOffers);
        } else {
            $this->ReshopOffers = $reshopOffers;
        }
        return $this;
    }
}
