<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReshopOrderChoiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reshop order Choice
 * @subpackage Structs
 */
class ReshopOrderChoiceType extends AbstractStructBase
{
    /**
     * The ServiceOrder
     * Meta information extracted from the WSDL
     * - documentation: Functions to allow a Seller to request additions, replacement or deletions of OrderItems in this specific Order.
     * - choice: ServiceOrder | UpdatePax | UpdatePaxName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceOrderType
     */
    public $ServiceOrder;
    /**
     * The UpdatePax
     * Meta information extracted from the WSDL
     * - documentation: Function to Add, Remove or Update the Passenger Details. Providing the New and Previous values together implies an Update.
     * - choice: ServiceOrder | UpdatePax | UpdatePaxName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\UpdatePaxType
     */
    public $UpdatePax;
    /**
     * The UpdatePaxName
     * Meta information extracted from the WSDL
     * - documentation: Request to Airline whether any fees will apply to a proposed correction to a Passenger's name details.
     * - choice: ServiceOrder | UpdatePax | UpdatePaxName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\UpdatePaxNameType
     */
    public $UpdatePaxName;
    /**
     * Constructor method for ReshopOrderChoiceType
     * @uses ReshopOrderChoiceType::setServiceOrder()
     * @uses ReshopOrderChoiceType::setUpdatePax()
     * @uses ReshopOrderChoiceType::setUpdatePaxName()
     * @param \StructType\ServiceOrderType $serviceOrder
     * @param \StructType\UpdatePaxType $updatePax
     * @param \StructType\UpdatePaxNameType $updatePaxName
     */
    public function __construct(\StructType\ServiceOrderType $serviceOrder = null, \StructType\UpdatePaxType $updatePax = null, \StructType\UpdatePaxNameType $updatePaxName = null)
    {
        $this
            ->setServiceOrder($serviceOrder)
            ->setUpdatePax($updatePax)
            ->setUpdatePaxName($updatePaxName);
    }
    /**
     * Get ServiceOrder value
     * @return \StructType\ServiceOrderType
     */
    public function getServiceOrder()
    {
        return isset($this->ServiceOrder) ? $this->ServiceOrder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceOrder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceOrderForChoiceConstraintsFromSetServiceOrder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UpdatePax',
            'UpdatePaxName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceOrder can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceOrder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceOrder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceOrderType $serviceOrder
     * @return \StructType\ReshopOrderChoiceType
     */
    public function setServiceOrder(\StructType\ServiceOrderType $serviceOrder = null)
    {
        // validation for constraint: choice(ServiceOrder, UpdatePax, UpdatePaxName)
        if ('' !== ($serviceOrderChoiceErrorMessage = self::validateServiceOrderForChoiceConstraintsFromSetServiceOrder($serviceOrder))) {
            throw new \InvalidArgumentException($serviceOrderChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceOrder) || (is_array($serviceOrder) && empty($serviceOrder))) {
            unset($this->ServiceOrder);
        } else {
            $this->ServiceOrder = $serviceOrder;
        }
        return $this;
    }
    /**
     * Get UpdatePax value
     * @return \StructType\UpdatePaxType
     */
    public function getUpdatePax()
    {
        return isset($this->UpdatePax) ? $this->UpdatePax : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUpdatePax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpdatePax method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUpdatePaxForChoiceConstraintsFromSetUpdatePax($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ServiceOrder',
            'UpdatePaxName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UpdatePax can\'t be set as the property %s is already set. Only one property must be set among these properties: UpdatePax, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UpdatePax value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UpdatePaxType $updatePax
     * @return \StructType\ReshopOrderChoiceType
     */
    public function setUpdatePax(\StructType\UpdatePaxType $updatePax = null)
    {
        // validation for constraint: choice(ServiceOrder, UpdatePax, UpdatePaxName)
        if ('' !== ($updatePaxChoiceErrorMessage = self::validateUpdatePaxForChoiceConstraintsFromSetUpdatePax($updatePax))) {
            throw new \InvalidArgumentException($updatePaxChoiceErrorMessage, __LINE__);
        }
        if (is_null($updatePax) || (is_array($updatePax) && empty($updatePax))) {
            unset($this->UpdatePax);
        } else {
            $this->UpdatePax = $updatePax;
        }
        return $this;
    }
    /**
     * Get UpdatePaxName value
     * @return \StructType\UpdatePaxNameType
     */
    public function getUpdatePaxName()
    {
        return isset($this->UpdatePaxName) ? $this->UpdatePaxName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUpdatePaxName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpdatePaxName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUpdatePaxNameForChoiceConstraintsFromSetUpdatePaxName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ServiceOrder',
            'UpdatePax',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UpdatePaxName can\'t be set as the property %s is already set. Only one property must be set among these properties: UpdatePaxName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UpdatePaxName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UpdatePaxNameType $updatePaxName
     * @return \StructType\ReshopOrderChoiceType
     */
    public function setUpdatePaxName(\StructType\UpdatePaxNameType $updatePaxName = null)
    {
        // validation for constraint: choice(ServiceOrder, UpdatePax, UpdatePaxName)
        if ('' !== ($updatePaxNameChoiceErrorMessage = self::validateUpdatePaxNameForChoiceConstraintsFromSetUpdatePaxName($updatePaxName))) {
            throw new \InvalidArgumentException($updatePaxNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($updatePaxName) || (is_array($updatePaxName) && empty($updatePaxName))) {
            unset($this->UpdatePaxName);
        } else {
            $this->UpdatePaxName = $updatePaxName;
        }
        return $this;
    }
}
